/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.sgl;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.sgl.Result;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class EdgeResult
implements Result {
    @JsonProperty
    private final String type = "edge";
    @JsonProperty
    private final String label;
    @JsonProperty
    private final Result from;
    @JsonProperty
    private final Result to;
    @JsonProperty
    private final Map<String, Object> properties;

    public EdgeResult(@JsonProperty(value="label") String label, @JsonProperty(value="from") Result from, @JsonProperty(value="to") Result to, @JsonProperty(value="properties") Map<String, Object> properties) {
        this.label = label;
        this.from = from;
        this.to = to;
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdgeResult that = (EdgeResult)o;
        return Objects.equals("edge", that.type) && Objects.equals(this.label, that.label) && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash("edge", this.label, this.from, this.to, this.properties);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.from.toString());
        sb.append(" -");
        sb.append(this.label);
        if (!this.properties.isEmpty()) {
            sb.append("(");
            sb.append(this.properties.entrySet().stream().map(e -> String.format("%s: %s", e.getKey(), e.getValue())).collect(Collectors.joining(", ")));
            sb.append(')');
        }
        sb.append("-> ");
        sb.append(this.to.toString());
        return sb.toString();
    }

    public String getType() {
        return "edge";
    }

    public String getLabel() {
        return this.label;
    }

    public Result getFrom() {
        return this.from;
    }

    public Result getTo() {
        return this.to;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

