/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar.types;

import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.types.CyclicTypeRecorder;
import com.sourceclear.rubysonar.types.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleType
implements Type {
    @NotNull
    private final String name;
    @NotNull
    private final String qname;
    @Nullable
    private final String file;
    @NotNull
    private final State table;

    public ModuleType(@NotNull String name, @Nullable String file, @NotNull State parent) {
        this.name = name;
        this.file = file;
        this.qname = parent.path.isEmpty() ? name : parent.path + "::" + name;
        this.table = new State(parent, State.StateType.MODULE);
        this.table.setPath(this.qname);
        this.table.setType(this);
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getQname() {
        return this.qname;
    }

    @Nullable
    public String getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public State getTable() {
        return this.table;
    }

    public int hashCode() {
        return "ModuleType".hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof ModuleType) {
            ModuleType co = (ModuleType)other;
            if (this.file != null) {
                return this.file.equals(co.file);
            }
        }
        return this == other;
    }

    @Override
    public String printType(CyclicTypeRecorder ctr) {
        return this.name;
    }

    @NotNull
    public String toString() {
        return this.printType(new CyclicTypeRecorder());
    }
}

