/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar.types;

import com.sourceclear.rubysonar.Builtins;
import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.types.ClassType;
import com.sourceclear.rubysonar.types.CyclicTypeRecorder;
import com.sourceclear.rubysonar.types.Type;
import org.jetbrains.annotations.NotNull;

public class IntType
implements Type {
    @NotNull
    private final State table;

    public IntType() {
        this(State.newGlobalTable());
    }

    public IntType(State globalTable) {
        Type fixnumClass = globalTable.lookupType("Fixnum");
        if (!(fixnumClass instanceof ClassType)) {
            fixnumClass = Builtins.initFixnumClass(globalTable, this);
        } else {
            Builtins.insertMethods(fixnumClass.getTable(), Builtins.fixnumMethods(this));
        }
        this.table = new State(globalTable, State.StateType.INSTANCE);
        this.table.setParent(fixnumClass.getTable());
        this.table.setPath(fixnumClass.getTable().path);
    }

    @Override
    public State getTable() {
        return this.table;
    }

    public int hashCode() {
        return "int".hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof IntType;
    }

    @Override
    public String printType(CyclicTypeRecorder ctr) {
        return "int";
    }

    @NotNull
    public String toString() {
        return this.printType(new CyclicTypeRecorder());
    }
}

