/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.rubysonar.types;

import com.sourceclear.rubysonar.State;
import com.sourceclear.rubysonar.types.CyclicTypeRecorder;
import com.sourceclear.rubysonar.types.Type;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BoolType
implements Type {
    @NotNull
    private final Value value;
    @NotNull
    private final State table;

    public BoolType(@NotNull Value value) {
        this(State.newGlobalTable(), value);
    }

    public BoolType(@NotNull State globalTable, @NotNull Value value) {
        this.table = new State(globalTable, State.StateType.INSTANCE);
        this.value = value;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoolType boolType = (BoolType)o;
        return this.value == boolType.value;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value});
    }

    @Override
    public String printType(CyclicTypeRecorder ctr) {
        return "bool";
    }

    @Override
    @NotNull
    public State getTable() {
        return this.table;
    }

    @NotNull
    public String toString() {
        return this.printType(new CyclicTypeRecorder());
    }

    public static enum Value {
        True,
        False,
        Undecided;

    }
}

