/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.types;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.State;
import com.sourceclear.pysonar.Utils;
import com.sourceclear.pysonar.types.Type;
import com.sourceclear.pysonar.types.TypeVisitor;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleType
extends Type {
    @NotNull
    public String name;
    @Nullable
    public String qname;

    public ModuleType(Analyzer analyzer, @NotNull String name, @Nullable Path file, @NotNull State parent) {
        super(analyzer);
        this.name = name;
        this.file = file;
        if (file != null) {
            this.qname = Utils.moduleQname(file);
        }
        if (this.qname == null) {
            this.qname = name;
        }
        this.setTable(new State(analyzer, parent, State.StateType.MODULE));
        this.table.setPath(this.qname);
        this.table.setType(this);
        if (analyzer.builtins != null) {
            this.table.addSuper(analyzer.builtins.BaseModule.table);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public int hashCode() {
        return "ModuleType".hashCode();
    }

    @Override
    public boolean typeEquals(Object other) {
        if (other instanceof ModuleType) {
            ModuleType co = (ModuleType)other;
            if (this.file != null) {
                return this.file.equals(co.file);
            }
        }
        return this == other;
    }

    @Override
    protected String printType(Type.CyclicTypeRecorder ctr) {
        return this.name;
    }

    @Override
    public <T> T accept(TypeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

