/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.types;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.State;
import com.sourceclear.pysonar.types.InstanceType;
import com.sourceclear.pysonar.types.Type;
import com.sourceclear.pysonar.types.TypeVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassType
extends Type {
    public String name;
    public InstanceType canon;
    public Type superclass;

    public ClassType(Analyzer analyzer, @NotNull String name, @Nullable State parent) {
        super(analyzer);
        this.name = name;
        this.setTable(new State(analyzer, parent, State.StateType.CLASS));
        this.table.setType(this);
        if (parent != null) {
            this.table.setPath(parent.extendPath(name));
        } else {
            this.table.setPath(name);
        }
    }

    public ClassType(Analyzer analyzer, @NotNull String name, State parent, @Nullable ClassType superClass) {
        this(analyzer, name, parent);
        if (superClass != null) {
            this.addSuper(superClass);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addSuper(@NotNull Type superclass) {
        this.superclass = superclass;
        this.table.addSuper(superclass.table);
    }

    public InstanceType getCanon() {
        if (this.canon == null) {
            this.canon = new InstanceType(this.analyzer, this);
        }
        return this.canon;
    }

    @Override
    public boolean typeEquals(Object other) {
        if (other instanceof ClassType) {
            return this.getCanon() == ((ClassType)other).getCanon();
        }
        return false;
    }

    @Override
    protected String printType(Type.CyclicTypeRecorder ctr) {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.name).append(">");
        return sb.toString();
    }

    @Override
    public <T> T accept(TypeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

