/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.ast;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.ast.Name;
import com.sourceclear.pysonar.ast.Node;
import com.sourceclear.pysonar.ast.NodeType;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FunctionDef
extends Node {
    public Name name;
    public List<Node> args;
    public List<Node> defaults;
    public Name vararg;
    public Name kwarg;
    public List<Node> afterRest = null;
    public Node body;
    public boolean called = false;
    public boolean isLamba = false;
    public boolean isAsync = false;

    public FunctionDef(Analyzer analyzer, Name name, List<Node> args, Node body, List<Node> defaults, Name vararg, Name kwarg, Path file, boolean isAsync, int lineNumber, int start, int end) {
        super(analyzer, NodeType.FUNCTIONDEF, file, lineNumber, start, end);
        if (name != null) {
            this.name = name;
        } else {
            this.isLamba = true;
            String fn = this.genLambdaName();
            this.name = new Name(analyzer, fn, file, lineNumber, start, start + "lambda".length());
            this.addChildren(this.name);
        }
        this.args = args;
        this.body = body;
        this.defaults = defaults;
        this.vararg = vararg;
        this.kwarg = kwarg;
        this.isAsync = isAsync;
        this.addChildren(name);
        this.addChildren(args);
        this.addChildren(defaults);
        this.addChildren(vararg, kwarg, this.body);
    }

    public String getArgumentExpr() {
        StringBuilder argExpr = new StringBuilder();
        argExpr.append("(");
        boolean first = true;
        for (Node n : this.args) {
            if (!first) {
                argExpr.append(", ");
            }
            first = false;
            argExpr.append(n.toDisplay());
        }
        if (this.vararg != null) {
            if (!first) {
                argExpr.append(", ");
            }
            first = false;
            argExpr.append("*" + this.vararg.toDisplay());
        }
        if (this.kwarg != null) {
            if (!first) {
                argExpr.append(", ");
            }
            argExpr.append("**" + this.kwarg.toDisplay());
        }
        argExpr.append(")");
        return argExpr.toString();
    }

    @NotNull
    public String genLambdaName() {
        return "lambda%" + this.analyzer.state.incrementLambdaCounter();
    }

    @Override
    @NotNull
    public String toString() {
        return "(func:" + this.start + ":" + this.name + ")";
    }
}

