/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar.ast;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.Binding;
import com.sourceclear.pysonar.Builtins;
import com.sourceclear.pysonar.State;
import com.sourceclear.pysonar.ast.Name;
import com.sourceclear.pysonar.ast.Node;
import com.sourceclear.pysonar.ast.NodeType;
import com.sourceclear.pysonar.types.Type;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ClassDef
extends Node {
    @NotNull
    public Name name;
    public List<Node> bases;
    public Node body;

    public ClassDef(Analyzer analyzer, @NotNull Name name, List<Node> bases, Node body, Path file, int lineNumber, int start, int end) {
        super(analyzer, NodeType.CLASSDEF, file, lineNumber, start, end);
        this.name = name;
        this.bases = bases;
        this.body = body;
        this.addChildren(name, this.body);
        this.addChildren(bases);
    }

    public void addSpecialAttribute(@NotNull State s, String name, Type proptype) {
        Binding b = new Binding(this.analyzer, name, Builtins.newTutUrl(this.analyzer, "classes.html"), proptype, Binding.Kind.ATTRIBUTE);
        s.update(name, b);
        b.markSynthetic();
        b.markStatic();
    }

    @Override
    @NotNull
    public String toString() {
        return "(class:" + this.name.id + ":" + this.start + ")";
    }
}

