/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.Binding;
import com.sourceclear.pysonar.Utils;
import com.sourceclear.pysonar.ast.Node;
import com.sourceclear.pysonar.types.ModuleType;
import com.sourceclear.pysonar.types.Type;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class State {
    @NotNull
    public Map<String, Set<Binding>> table = new HashMap<String, Set<Binding>>(0);
    @Nullable
    public State parent;
    @Nullable
    public State forwarding;
    @Nullable
    public List<State> supers;
    @Nullable
    public Set<String> globalNames;
    public StateType stateType;
    public Type type;
    @NotNull
    public String path = "";
    private final Analyzer analyzer;

    public State(Analyzer analyzer, @Nullable State parent, StateType type) {
        this.analyzer = analyzer;
        this.parent = parent;
        this.stateType = type;
        this.forwarding = type == StateType.CLASS ? (parent == null ? null : parent.getForwarding()) : this;
    }

    public State(Analyzer analyzer, @NotNull State s) {
        this.analyzer = analyzer;
        this.table = new HashMap<String, Set<Binding>>();
        this.table.putAll(s.table);
        this.parent = s.parent;
        this.stateType = s.stateType;
        this.forwarding = s.forwarding;
        this.supers = s.supers;
        this.globalNames = s.globalNames;
        this.type = s.type;
        this.path = s.path;
    }

    public void overwrite(@NotNull State s) {
        this.table = s.table;
        this.parent = s.parent;
        this.stateType = s.stateType;
        this.forwarding = s.forwarding;
        this.supers = s.supers;
        this.globalNames = s.globalNames;
        this.type = s.type;
        this.path = s.path;
    }

    @NotNull
    public State copy() {
        return new State(this.analyzer, this);
    }

    public void merge(State other) {
        for (Map.Entry<String, Set<Binding>> entry : other.table.entrySet()) {
            Set<Binding> thisBinding = this.table.get(entry.getKey());
            Set<Binding> thatBinding = entry.getValue();
            if (thisBinding != null && thatBinding != null) {
                HashSet<Binding> mergeResult = new HashSet<Binding>(thisBinding);
                mergeResult.addAll(thatBinding);
                this.table.put(entry.getKey(), mergeResult);
                continue;
            }
            if (thisBinding != null || thatBinding == null) continue;
            this.table.put(entry.getKey(), thatBinding);
        }
    }

    public static State merge(State state1, State state2) {
        State ret = state1.copy();
        ret.merge(state2);
        return ret;
    }

    public void setParent(@Nullable State parent) {
        this.parent = parent;
    }

    public State getForwarding() {
        if (this.forwarding != null) {
            return this.forwarding;
        }
        return this;
    }

    public void addSuper(State sup) {
        if (this.supers == null) {
            this.supers = new ArrayList<State>();
        }
        this.supers.add(sup);
    }

    public void setStateType(StateType type) {
        this.stateType = type;
    }

    public void addGlobalName(@NotNull String name) {
        if (this.globalNames == null) {
            this.globalNames = new HashSet<String>(1);
        }
        this.globalNames.add(name);
    }

    public boolean isGlobalName(@NotNull String name) {
        if (this.globalNames != null) {
            return this.globalNames.contains(name);
        }
        if (this.parent != null) {
            return this.parent.isGlobalName(name);
        }
        return false;
    }

    public void remove(String id) {
        this.table.remove(id);
    }

    public void insert(String id, @NotNull Node node, @NotNull Type type, Binding.Kind kind) {
        Binding b = new Binding(this.analyzer, id, node, type, kind);
        if (type instanceof ModuleType) {
            b.setQname(type.asModuleType().qname);
        } else {
            b.setQname(this.extendPath(id));
        }
        this.update(id, b);
    }

    @NotNull
    public Set<Binding> update(String id, @NotNull Set<Binding> bs) {
        this.table.put(id, bs);
        return bs;
    }

    @NotNull
    public Set<Binding> update(String id, @NotNull Binding b) {
        HashSet<Binding> bs = new HashSet<Binding>(1);
        bs.add(b);
        this.table.put(id, bs);
        return bs;
    }

    public void setPath(@NotNull String path) {
        this.path = path;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Nullable
    public Set<Binding> lookupLocal(String name) {
        return this.table.get(name);
    }

    @Nullable
    public Set<Binding> lookup(@NotNull String name) {
        Set<Binding> b = this.getModuleBindingIfGlobal(name);
        if (b != null) {
            return b;
        }
        Set<Binding> ent = this.lookupLocal(name);
        if (ent != null) {
            return ent;
        }
        if (this.parent != null) {
            return this.parent.lookup(name);
        }
        return null;
    }

    @Nullable
    public Set<Binding> lookupScope(String name) {
        Set<Binding> bindings = this.getModuleBindingIfGlobal(name);
        if (bindings != null) {
            return bindings;
        }
        return this.lookupLocal(name);
    }

    @Nullable
    public Set<Binding> lookupAttr(String attr) {
        if (this.analyzer.state.wasStateSeen(this)) {
            return null;
        }
        Set<Binding> bindings = this.lookupLocal(attr);
        if (bindings != null) {
            return bindings;
        }
        if (this.supers != null && !this.supers.isEmpty()) {
            this.analyzer.state.seenState(this);
            for (State parentState : this.supers) {
                bindings = parentState.lookupAttr(attr);
                if (bindings == null) continue;
                this.analyzer.state.forgetState(this);
                return bindings;
            }
            this.analyzer.state.forgetState(this);
            return null;
        }
        return null;
    }

    @Nullable
    public Type lookupType(String name) {
        Set<Binding> bindings = this.lookup(name);
        if (bindings == null) {
            return null;
        }
        return this.analyzer.makeUnion(bindings);
    }

    @Nullable
    public Type lookupAttrType(String attr) {
        Set<Binding> bindings = this.lookupAttr(attr);
        if (bindings == null) {
            return null;
        }
        return this.analyzer.makeUnion(bindings);
    }

    @Nullable
    public State getStateOfType(StateType type) {
        if (this.stateType == type) {
            return this;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getStateOfType(type);
    }

    @NotNull
    public State getGlobalTable() {
        State result = this.getStateOfType(StateType.MODULE);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Couldn't find global table. Shouldn't happen");
    }

    @Nullable
    private Set<Binding> getModuleBindingIfGlobal(@NotNull String name) {
        State module;
        if (this.isGlobalName(name) && (module = this.getGlobalTable()) != this) {
            return module.lookupLocal(name);
        }
        return null;
    }

    public void putAll(@NotNull State other) {
        this.table.putAll(other.table);
    }

    @NotNull
    public Set<String> keySet() {
        return this.table.keySet();
    }

    @NotNull
    public Collection<Binding> values() {
        HashSet<Binding> ret = new HashSet<Binding>();
        for (Set<Binding> bs : this.table.values()) {
            ret.addAll(bs);
        }
        return ret;
    }

    @NotNull
    public Set<Map.Entry<String, Set<Binding>>> entrySet() {
        return this.table.entrySet();
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    @NotNull
    public String extendPath(@NotNull String name) {
        String moduleName = Utils.moduleName(Paths.get(name, new String[0]));
        if (this.path.equals("")) {
            return moduleName;
        }
        return this.path + "." + moduleName;
    }

    @NotNull
    public String toString() {
        return "<State:" + (Object)((Object)this.stateType) + ":" + this.table.keySet() + ">";
    }

    public static enum StateType {
        CLASS,
        INSTANCE,
        FUNCTION,
        MODULE,
        GLOBAL,
        SCOPE;

    }
}

