/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.pysonar;

import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.ast.ClassDef;
import com.sourceclear.pysonar.ast.FunctionDef;
import com.sourceclear.pysonar.ast.Module;
import com.sourceclear.pysonar.ast.Name;
import com.sourceclear.pysonar.ast.Node;
import com.sourceclear.pysonar.ast.Str;
import com.sourceclear.pysonar.ast.Url;
import com.sourceclear.pysonar.types.ModuleType;
import com.sourceclear.pysonar.types.Type;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Binding
implements Comparable<Object> {
    private final Analyzer analyzer;
    private boolean isStatic = false;
    private boolean isSynthetic = false;
    private boolean isBuiltin = false;
    @NotNull
    public String name;
    @NotNull
    public Node node;
    @NotNull
    public String qname;
    public Type type;
    public Kind kind;
    public Set<Node> refs = new LinkedHashSet<Node>(1);
    public int start = -1;
    public int end = -1;
    public int bodyStart = -1;
    public int bodyEnd = -1;
    @Nullable
    public String fileOrUrl;

    public Binding(Analyzer analyzer, @NotNull String id, @NotNull Node node, @NotNull Type type, @NotNull Kind kind) {
        this.name = id;
        this.qname = type.table.path;
        this.type = type;
        this.kind = kind;
        this.node = node;
        if (node instanceof Url) {
            String url = ((Url)node).url;
            this.fileOrUrl = url.startsWith("file://") ? url.substring("file://".length()) : url;
        } else {
            String string = this.fileOrUrl = node.getFile() == null ? null : node.getFile().toAbsolutePath().toString();
            if (node instanceof Name) {
                this.name = ((Name)node).id;
            }
        }
        this.initLocationInfo(node);
        analyzer.state.registerBinding(this);
        this.analyzer = analyzer;
    }

    private void initLocationInfo(Node node) {
        this.start = node.start;
        this.end = node.end;
        Node parent = node.parent;
        if (parent instanceof FunctionDef && ((FunctionDef)parent).name == node || parent instanceof ClassDef && ((ClassDef)parent).name == node) {
            this.bodyStart = parent.start;
            this.bodyEnd = parent.end;
        } else if (node instanceof Module) {
            this.name = ((Module)node).name;
            this.start = 0;
            this.end = 0;
            this.bodyStart = node.start;
            this.bodyEnd = node.end;
        } else {
            this.bodyStart = node.start;
            this.bodyEnd = node.end;
        }
    }

    public Str getDocstring() {
        Node parent = this.node.parent;
        if (parent instanceof FunctionDef && ((FunctionDef)parent).name == this.node || parent instanceof ClassDef && ((ClassDef)parent).name == this.node) {
            return parent.getDocString();
        }
        return this.node.getDocString();
    }

    public void setQname(@NotNull String qname) {
        this.qname = qname;
    }

    public void addRef(Node node) {
        this.refs.add(node);
    }

    public void addType(Type t) {
        this.type = this.analyzer.union(this.type, t);
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public void markStatic() {
        this.isStatic = true;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void markSynthetic() {
        this.isSynthetic = true;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean isBuiltin() {
        return this.isBuiltin;
    }

    @NotNull
    public String getFirstFile() {
        Type bt = this.type;
        if (bt instanceof ModuleType) {
            Path file = bt.asModuleType().file;
            return file != null ? file.toAbsolutePath().toString() : "<built-in module>";
        }
        String file = this.getFile();
        if (file != null) {
            return file;
        }
        return "<built-in binding>";
    }

    @Nullable
    public String getFile() {
        return this.isURL() ? null : this.fileOrUrl;
    }

    @Nullable
    public String getURL() {
        return this.isURL() ? this.fileOrUrl : null;
    }

    public boolean isURL() {
        return this.fileOrUrl != null && this.fileOrUrl.startsWith("http://");
    }

    @Override
    public int compareTo(@NotNull Object o) {
        return this.start - ((Binding)o).start;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(binding:");
        sb.append(":kind=").append((Object)this.kind);
        sb.append(":node=").append(this.node);
        sb.append(":type=").append(this.type);
        sb.append(":qname=").append(this.qname);
        sb.append(":refs=");
        if (this.refs.size() > 10) {
            sb.append("[");
            sb.append(this.refs.iterator().next());
            sb.append(", ...(");
            sb.append(this.refs.size() - 1);
            sb.append(" more)]");
        } else {
            sb.append(this.refs);
        }
        sb.append(">");
        return sb.toString();
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public static enum Kind {
        ATTRIBUTE,
        CLASS,
        CONSTRUCTOR,
        FUNCTION,
        METHOD,
        MODULE,
        PARAMETER,
        SCOPE,
        VARIABLE;

    }
}

