/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.publicmethods.python;

import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.pysonar.Analyzer;
import com.sourceclear.pysonar.PythonProjectFileVisitor;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public abstract class PythonProjectAnalysis {
    private final Path fileOrDirectory;
    private final VulnMethodsConfig config;

    public PythonProjectAnalysis(Path fileOrDirectory, VulnMethodsConfig config) {
        this.fileOrDirectory = fileOrDirectory;
        this.config = config;
    }

    public abstract void analyseSourceFile(Analyzer var1, Path var2, Path var3) throws IOException;

    public void run() throws IOException {
        final Analyzer analyzer = new Analyzer(this.config);
        if (Files.isRegularFile(this.fileOrDirectory, new LinkOption[0])) {
            Path projectDir = this.fileOrDirectory.getParent();
            this.analyseSourceFile(analyzer, projectDir, this.fileOrDirectory);
            return;
        }
        analyzer.init(this.fileOrDirectory);
        final Path projectDir = analyzer.projectDir;
        try {
            Files.walkFileTree(projectDir, new PythonProjectFileVisitor(this.config){

                @Override
                public FileVisitResult visitPythonFile(Path file, BasicFileAttributes attrs) throws IOException {
                    PythonProjectAnalysis.this.analyseSourceFile(analyzer, projectDir, file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        finally {
            analyzer.close();
        }
    }
}

