/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.sourceclear.methods.Cleaner;
import com.sourceclear.methods.EntryPointResolver;
import com.sourceclear.methods.JavaCallGraphBuilder;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodScanner;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.methods.VulnerablePartsDetector;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarInputStream;

public class JavaMethodScannerFactory
extends MethodScannerFactory {
    private final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:*.class");

    @Override
    public VulnMethodsConfig.Builder defaultVulnMethodsConfig() {
        return VulnMethodsConfig.Builder.java();
    }

    @Override
    public MethodScanner forArchiveStream(InputStream archiveStream, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        JavaCallGraphBuilder callGraphBuilder = new JavaCallGraphBuilder(new JarInputStream(archiveStream), this.config.parallel());
        return new VulnerablePartsDetector(vulnerableMethods, entryPointResolver, callGraphBuilder, Cleaner.DO_NOTHING);
    }

    @Override
    public MethodScanner forFiles(Collection<Path> files, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        JavaCallGraphBuilder callGraphBuilder = new JavaCallGraphBuilder(files, this.config.parallel());
        return new VulnerablePartsDetector(vulnerableMethods, entryPointResolver, callGraphBuilder, Cleaner.DO_NOTHING);
    }

    @Override
    public MethodScanner forDirectory(Path directory, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        if (Files.isDirectory(directory, new LinkOption[0])) {
            JavaCallGraphBuilder callGraphBuilder = new JavaCallGraphBuilder((Collection<Path>)this.getClassFiles(directory), this.config.parallel());
            return new VulnerablePartsDetector(vulnerableMethods, entryPointResolver, callGraphBuilder, Cleaner.DO_NOTHING);
        }
        throw new IOException(String.format("Not a directory: %s", directory));
    }

    private List<Path> getClassFiles(Path directory) throws IOException {
        final ArrayList<Path> classFiles = new ArrayList<Path>();
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (JavaMethodScannerFactory.this.config.ignoredDirectories().contains(dir.getFileName().toString())) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (Files.isReadable(file) && JavaMethodScannerFactory.this.matcher.matches(file.getFileName())) {
                    classFiles.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return classFiles;
    }
}

