/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.CallGraphBuilderMethodVisitor;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.ClassInfo;
import com.sourceclear.methods.MethodInfo;
import com.zaxxer.sparsebits.SparseBitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class CallGraphClassVisitor
extends ClassVisitor {
    private final int version;
    private final String className;
    private final Map<String, SparseBitSet> cones;
    private final Map<MethodInfo, SparseBitSet> appliesTo;
    private final List<String> integerToClass;
    private final Map<String, ClassInfo> classNameToClassInfo;
    private final Map<String, Set<MethodInfo>> classToAppliesToMethods;
    private final Collection<MethodInfo> reflectedMethods;
    private Map<String, Integer> classToInteger;
    private final SparseBitSet instantiatedTypes;
    private final Set<CallSite> callSites = new HashSet<CallSite>();

    CallGraphClassVisitor(Data data) {
        super(data.getVersion());
        this.version = data.getVersion();
        this.className = data.getClassName();
        this.cones = data.getCones();
        this.appliesTo = data.getAppliesTo();
        this.integerToClass = data.getIntegerToClass();
        this.classNameToClassInfo = data.getClassNameToClassInfo();
        this.instantiatedTypes = data.getInstantiatedTypes();
        this.classToAppliesToMethods = data.getClassToAppliesToMethods();
        this.reflectedMethods = data.getReflectedMethods();
        this.classToInteger = data.getClassToInteger();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodInfo caller = new MethodInfo(this.className, name, Utils.stripReturnType(desc), Utils.attributesFromAccess(access));
        return new CallGraphBuilderMethodVisitor(this.version, caller, this.cones, this.appliesTo, this.integerToClass, this.classNameToClassInfo, this.instantiatedTypes, this.classToAppliesToMethods, this.reflectedMethods, this.classToInteger, this.callSites);
    }

    public static Data builder() {
        return new Data();
    }

    public Set<CallSite> getCallSites() {
        return this.callSites;
    }

    static class Data {
        private int version;
        private String className;
        private Map<String, SparseBitSet> cones;
        private Map<MethodInfo, SparseBitSet> appliesTo;
        private List<String> integerToClass;
        private Map<String, ClassInfo> classNameToClassInfo;
        private Map<String, Set<MethodInfo>> classToAppliesToMethods;
        private Collection<MethodInfo> reflectedMethods;
        private Map<String, Integer> classToInteger;
        private SparseBitSet instantiatedTypes;

        Data() {
        }

        Data withVersion(int version) {
            this.version = version;
            return this;
        }

        Data withClassName(String className) {
            this.className = className;
            return this;
        }

        Data withCones(Map<String, SparseBitSet> cones) {
            this.cones = cones;
            return this;
        }

        Data withAppliesTo(Map<MethodInfo, SparseBitSet> appliesTo) {
            this.appliesTo = appliesTo;
            return this;
        }

        Data withIntegerToClass(List<String> integerToClass) {
            this.integerToClass = integerToClass;
            return this;
        }

        Data withClassNameToClassInfo(Map<String, ClassInfo> classNameToClassInfo) {
            this.classNameToClassInfo = classNameToClassInfo;
            return this;
        }

        Data withClassToAppliesToMethods(Map<String, Set<MethodInfo>> classToAppliesToMethods) {
            this.classToAppliesToMethods = classToAppliesToMethods;
            return this;
        }

        Data withReflectedMethods(Collection<MethodInfo> reflectedMethods) {
            this.reflectedMethods = reflectedMethods;
            return this;
        }

        Data withClassToInteger(Map<String, Integer> classToInteger) {
            this.classToInteger = classToInteger;
            return this;
        }

        Data withInstantiatedTypes(SparseBitSet instantiatedTypes) {
            this.instantiatedTypes = instantiatedTypes;
            return this;
        }

        int getVersion() {
            return this.version;
        }

        String getClassName() {
            return this.className;
        }

        Map<String, SparseBitSet> getCones() {
            return this.cones;
        }

        Map<MethodInfo, SparseBitSet> getAppliesTo() {
            return this.appliesTo;
        }

        List<String> getIntegerToClass() {
            return this.integerToClass;
        }

        Map<String, ClassInfo> getClassNameToClassInfo() {
            return this.classNameToClassInfo;
        }

        Map<String, Set<MethodInfo>> getClassToAppliesToMethods() {
            return this.classToAppliesToMethods;
        }

        Collection<MethodInfo> getReflectedMethods() {
            return this.reflectedMethods;
        }

        Map<String, Integer> getClassToInteger() {
            return this.classToInteger;
        }

        SparseBitSet getInstantiatedTypes() {
            return this.instantiatedTypes;
        }

        CallGraphClassVisitor build() {
            return new CallGraphClassVisitor(this);
        }
    }
}

