/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.google.common.base.Strings;
import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.BitSetIterator;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.ClassInfo;
import com.sourceclear.methods.Constants;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodInvocation;
import com.zaxxer.sparsebits.SparseBitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class CallGraphBuilderMethodVisitor
extends MethodVisitor {
    private static final String SUBMIT_CALLABLE_DESC = "(Ljava/lang/Callable;)";
    private static final String SUBMIT_RUNNABLE_DESC = "(Ljava/lang/Runnable;Ljava/lang/Object;)";
    private final MethodInfo caller;
    private final Map<String, SparseBitSet> cones;
    private final Map<MethodInfo, SparseBitSet> appliesTos;
    private final List<String> integerToClass;
    private final Map<String, ClassInfo> classNameToClassInfo;
    private final Map<String, Set<MethodInfo>> classToAppliesToMethods;
    private final Collection<MethodInfo> reflectedMethods;
    private final Map<String, Integer> classToInteger;
    private final SparseBitSet instantiatedTypes;
    private int currentLine;
    private String currentLoadedString;
    private final String fileName;
    private final Set<CallSite> callSites;

    CallGraphBuilderMethodVisitor(int version, MethodInfo caller, Map<String, SparseBitSet> cones, Map<MethodInfo, SparseBitSet> appliesTos, List<String> integerToClass, Map<String, ClassInfo> classNameToClassInfo, SparseBitSet instantiatedTypes, Map<String, Set<MethodInfo>> classToAppliesToMethods, Collection<MethodInfo> reflectedMethods, Map<String, Integer> classToInteger, Set<CallSite> callSites) {
        super(version);
        this.caller = caller;
        this.fileName = this.toFileName(caller.getClassName());
        this.cones = cones;
        this.appliesTos = appliesTos;
        this.integerToClass = integerToClass;
        this.classNameToClassInfo = classNameToClassInfo;
        this.instantiatedTypes = instantiatedTypes;
        this.classToAppliesToMethods = classToAppliesToMethods;
        this.reflectedMethods = reflectedMethods;
        this.classToInteger = classToInteger;
        this.callSites = callSites;
    }

    public void visitMethodInsn(int opcode, String receiver, String name, String desc, boolean itf) {
        super.visitMethodInsn(opcode, receiver, name, desc, itf);
        MethodInvocation invocation = new MethodInvocation(opcode, new MethodInfo(receiver, name, Utils.stripReturnType(desc)));
        if (invocation.equals(Constants.INVOKE_METHOD_INVOCATION)) {
            for (MethodInfo method : this.reflectedMethods) {
                CallSite callSite = new CallSite(this.caller, method, this.fileName, this.currentLine);
                this.callSites.add(callSite);
            }
            return;
        }
        if (invocation.equals(Constants.FOR_NAME_METHOD_INVOCATION) && !Strings.isNullOrEmpty((String)this.currentLoadedString)) {
            MethodInfo clinit = new MethodInfo(Utils.classNameToInternalName(this.currentLoadedString), "<clinit>", "()");
            CallSite callSite = new CallSite(this.caller, clinit, this.fileName, this.currentLine);
            this.callSites.add(callSite);
            return;
        }
        MethodInfo callee = new MethodInfo(receiver, name, Utils.stripReturnType(desc));
        SparseBitSet cone = this.cones.get(receiver);
        if (cone == null || opcode == 183 || opcode == 184) {
            ClassInfo classInfo;
            MethodInfo method;
            if (this.classNameToClassInfo.containsKey(receiver) && (method = (classInfo = this.classNameToClassInfo.get(receiver)).getMethodFromNameAndDesc(callee.getMethodName(), callee.getDesc())) != null) {
                CallSite callSite = new CallSite(this.caller, method, this.fileName, this.currentLine);
                this.callSites.add(callSite);
                return;
            }
            CallSite callSite = new CallSite(this.caller, callee, this.fileName, this.currentLine);
            this.callSites.add(callSite);
            return;
        }
        if (this.isStartingThread(callee) || this.isExecutingThreadThroughExecutor(callee) || this.isExecutingThreadThroughExecutorService(callee) || this.isExecutingThreadThroughCompletionService(callee)) {
            this.addVirtualEdge("run", "()", this.cones.get("java/lang/Runnable"));
        }
        if (this.isExecutingCallableThroughExecutorService(callee) || this.isExecutingCallableThroughCompletionService(callee)) {
            this.addVirtualEdge("call", "()", this.cones.get("java/util/concurrent/Callable"));
        } else {
            this.addVirtualEdge(callee.getMethodName(), callee.getDesc(), cone);
        }
        Collection methods = this.classToAppliesToMethods.getOrDefault(receiver, Collections.emptySet());
        for (MethodInfo method : methods) {
            boolean hasSameNameAndDesc = method.getMethodName().equals(callee.getMethodName()) && method.getDesc().equals(callee.getDesc());
            boolean isAbstract = method.getAttributes().contains((Object)MethodInfo.Attribute.ABSTRACT);
            if (!hasSameNameAndDesc || isAbstract) continue;
            SparseBitSet appliesTo = this.appliesTos.get(method);
            for (Integer i : new BitSetIterator(appliesTo)) {
                String className = this.integerToClass.get(i);
                MethodInfo m = new MethodInfo(className, name, Utils.stripReturnType(desc));
                CallSite callSite = new CallSite(this.caller, m, this.fileName, this.currentLine);
                this.callSites.remove(callSite);
            }
            this.callSites.add(new CallSite(this.caller, method, this.fileName, this.currentLine));
        }
    }

    private void addVirtualEdge(String methodName, String desc, SparseBitSet cone) {
        for (Integer i : new BitSetIterator(cone)) {
            MethodInfo coneCallee;
            MethodInfo method;
            ClassInfo classInfo;
            boolean classNotInstantiated = !this.instantiatedTypes.get(i.intValue());
            String className = this.integerToClass.get(i);
            if (classNotInstantiated || (classInfo = this.classNameToClassInfo.get(className)) == null || (method = classInfo.getMethodFromNameAndDesc((coneCallee = new MethodInfo(className, methodName, Utils.stripReturnType(desc))).getMethodName(), coneCallee.getDesc())) == null) continue;
            CallSite callSite = new CallSite(this.caller, coneCallee, this.fileName, this.currentLine);
            this.callSites.add(callSite);
        }
    }

    private boolean isExecutingCallableThroughCompletionService(MethodInfo callee) {
        return this.isExecutingThroughCompletionService(callee, SUBMIT_CALLABLE_DESC);
    }

    private boolean isExecutingThreadThroughCompletionService(MethodInfo callee) {
        return this.isExecutingThroughCompletionService(callee, SUBMIT_RUNNABLE_DESC);
    }

    private boolean isExecutingThroughCompletionService(MethodInfo callee, String submitMethodDesc) {
        String methodName = callee.getMethodName();
        String desc = callee.getDesc();
        String className = callee.getClassName();
        boolean implementsCompletionService = this.isInConeSet("java/util/concurrent/CompletionService", className);
        boolean isCallingSubmit = methodName.equals("submit") && desc.equals(submitMethodDesc);
        return isCallingSubmit && (className.equals("java/util/concurrent/CompletionService") || implementsCompletionService);
    }

    private boolean isExecutingThreadThroughExecutorService(MethodInfo callee) {
        String methodName = callee.getMethodName();
        String desc = callee.getDesc();
        String className = callee.getClassName();
        boolean implementsExecutorService = this.isInConeSet("java/util/concurrent/ExecutorService", className);
        boolean isCallingSubmit = methodName.equals("submit") && (desc.equals(SUBMIT_RUNNABLE_DESC) || desc.equals("(Ljava/lang/Runnable;"));
        return isCallingSubmit && (className.equals("java/util/concurrent/ExecutorService") || implementsExecutorService);
    }

    private boolean isExecutingCallableThroughExecutorService(MethodInfo callee) {
        String methodName = callee.getMethodName();
        String desc = callee.getDesc();
        String className = callee.getClassName();
        boolean implementsExecutorService = this.isInConeSet("java/util/concurrent/ExecutorService", className);
        boolean isCallingSubmit = methodName.equals("submit") && desc.equals("(Ljava/util/concurrent/Callable;)");
        boolean isCallingInvokeAll = methodName.equals("invokeAll") && (desc.equals("(Ljava/util/Collection;)") || desc.equals("(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)"));
        boolean isCallingInvokeAny = methodName.equals("invokeAny") && (desc.equals("(Ljava/util/Collection;)") || desc.equals("(Ljava/util/Collection;JLjava/util/concurrent/TimeUnit;)"));
        return !(!isCallingInvokeAll && !isCallingInvokeAny && !isCallingSubmit || !className.equals("java/util/concurrent/ExecutorService") && !implementsExecutorService);
    }

    private boolean isExecutingThreadThroughExecutor(MethodInfo callee) {
        boolean implementsExecutor = this.isInConeSet("java/util/concurrent/Executor", callee.getClassName());
        return callee.getMethodName().equals("execute") && callee.getDesc().equals("(Ljava/lang/Runnable;)") && (callee.getClassName().equals("java/util/concurrent/Executor") || implementsExecutor);
    }

    private boolean isStartingThread(MethodInfo callee) {
        boolean isAThread = this.isInConeSet("java/lang/Thread", callee.getClassName());
        return callee.getMethodName().equals("start") && callee.getDesc().equals("()") && isAThread;
    }

    public void visitLdcInsn(Object arg) {
        if (arg instanceof String) {
            this.currentLoadedString = (String)arg;
        }
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.currentLine = line;
    }

    private boolean isInConeSet(String classA, String classB) {
        SparseBitSet cone = this.cones.get(classA);
        return cone != null && this.cones.get(classA).get(this.classToInteger.get(classB).intValue());
    }

    private String toFileName(String className) {
        return className + ".class";
    }
}

