/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sourceclear.methods.CallChain;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.sgl.TinkerPop;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class CallChainsInspector {
    private final CallGraph callGraph;

    CallChainsInspector(CallGraph callGraph) {
        this.callGraph = callGraph;
    }

    Map<MethodInfo, Collection<CallChain>> callChainsFrom(Collection<MethodInfo> targetMethods) {
        Graph graph = this.callGraph.getGraph();
        Set<Map<String, Object>> ids = targetMethods.stream().filter(this.callGraph::containsVertex).map(this.callGraph::getVertex).map(v -> (Map)v.id()).collect(Collectors.toSet());
        Map chains = TinkerPop.withStartingVertices(graph, ids, "called_by*(exclusive) path(with_edges)", t -> (Map)t.group().by((Traversal)__.tail((Scope)Scope.local, (long)1L)).map(x -> Maps.transformValues((Map)((Map)x.get()), CallChainsInspector::keepShortestPathsPerVulnMethod)).next());
        Map result = chains.entrySet().stream().collect(Collectors.toMap(e -> this.callGraph.getMethodInfo((Vertex)e.getKey()), e -> ((List)e.getValue()).stream().map(p -> {
            List collect = CallChainsInspector.alternatingPairs(p.objects(), (v1, edge, v2) -> CallGraph.toCallSite(this.callGraph.getMethodInfo((Vertex)v2), edge, this.callGraph.getMethodInfo((Vertex)v1))).collect(Collectors.toList());
            return new CallChain(Lists.reverse(collect));
        }).collect(Collectors.toSet()), CallChainsInspector.throwingMerger(), HashMap::new));
        for (MethodInfo targetMethod : targetMethods) {
            result.putIfAbsent(targetMethod, Collections.emptyList());
        }
        return result;
    }

    private static List<Path> keepShortestPathsPerVulnMethod(List<Path> originalPaths) {
        HashMap<Vertex, Set<Path>> result = new HashMap<Vertex, Set<Path>>();
        for (Path candidatePath : originalPaths) {
            boolean occursModuloEdges;
            Set<Path> paths;
            Vertex vm = (Vertex)candidatePath.get(0);
            if (!result.containsKey(vm)) {
                paths = new HashSet<Path>();
                paths.add(candidatePath);
                result.put(vm, paths);
                continue;
            }
            paths = (Set)result.get(vm);
            int currentShortest = ((Path)paths.iterator().next()).size();
            if (candidatePath.size() < currentShortest) {
                paths.clear();
                paths.add(candidatePath);
                continue;
            }
            if (candidatePath.size() != currentShortest || (occursModuloEdges = CallChainsInspector.checkVertexPathMembership(candidatePath, paths))) continue;
            paths.add(candidatePath);
        }
        return result.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static boolean checkVertexPathMembership(Path candidatePath, Set<Path> paths) {
        Stream<Set> verticesOnly = paths.stream().map(p -> p.objects().stream().filter(q -> q instanceof Vertex).map(q -> (Vertex)q).collect(Collectors.toSet()));
        Set verticesInPath = candidatePath.objects().stream().filter(q -> q instanceof Vertex).map(q -> (Vertex)q).collect(Collectors.toSet());
        return verticesOnly.anyMatch(path -> path.equals(verticesInPath));
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    private static <V, E, R> Stream<R> alternatingPairs(List<?> collection, Function3<V, E, V, R> callback) {
        if (collection.size() < 3) {
            return Stream.of(new Object[0]);
        }
        return IntStream.range(0, (collection.size() - 1) / 2).map(i -> i * 2).mapToObj(i -> callback.apply(collection.get(i), collection.get(i + 1), collection.get(i + 2)));
    }

    @FunctionalInterface
    public static interface Function3<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

