/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.librarydiffs.delta;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.sourceclear.librarydiffs.delta.DeltaMethod;
import com.sourceclear.librarydiffs.delta.LibDelta;
import com.sourceclear.librarydiffs.delta.Op;
import com.sourceclear.methods.MethodInfo;
import java.io.IOException;
import java.util.HashMap;

class Deserializer
extends StdDeserializer<LibDelta> {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    Deserializer() {
        this(null);
    }

    Deserializer(Class<LibDelta> t) {
        super(t);
    }

    public LibDelta deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (!node.isArray()) {
            throw new IOException("Not an array: " + node);
        }
        HashMap<MethodInfo, Op> result = new HashMap<MethodInfo, Op>();
        for (JsonNode child : node) {
            DeltaMethod method = (DeltaMethod)MAPPER.treeToValue((TreeNode)child, DeltaMethod.class);
            result.put(method.getMethod(), method.getOp());
        }
        return new LibDelta(result);
    }
}

