/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.librarydiffs;

import com.sourceclear.librarydiffs.delta.LibDelta;
import com.sourceclear.methods.MethodInfo;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class DeltaComposition {
    private final Set<Error> errors;
    private LibDelta delta;

    public DeltaComposition(LibDelta delta, Set<Error> errors) {
        this.errors = errors;
        this.delta = delta;
    }

    public DeltaComposition() {
        this(new LibDelta(), new HashSet<Error>());
    }

    public void compose(LibDelta other) {
        DeltaComposition result = this.delta.compose(other);
        this.delta = result.getDelta();
        this.errors.addAll(result.getErrors());
    }

    public String summarizeErrors() {
        if (this.errors.isEmpty()) {
            return "no errors";
        }
        return String.format("%d errors, with one being: %s", this.errors.size(), this.errors.iterator().next());
    }

    public Set<Error> getErrors() {
        return this.errors;
    }

    public LibDelta getDelta() {
        return this.delta;
    }

    public static class Error {
        private final MethodInfo method;
        private final String message;

        public Error(MethodInfo method, String message) {
            this.method = method;
            this.message = message;
        }

        public String toString() {
            return String.format("Could not compose diffs for method %s: %s", this.method, this.message);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Error error = (Error)o;
            return Objects.equals(this.method, error.method) && Objects.equals(this.message, error.message);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.message);
        }
    }
}

