/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.sourceclear.engine.common.StoredFileVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.methods.MethodScanBatcher;
import com.sourceclear.methods.CallChain;
import com.sourceclear.methods.EntryPointResolver;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodScanner;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.PermissiveEntryPointResolver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

final class SimpleFileMethodScanBatcher
extends MethodScanBatcher {
    private final EntryPointResolver ENTRY_POINT_RESOLVER = new PermissiveEntryPointResolver();
    private final StoredFileVisitor visitor;
    private final MethodScannerFactory methodScannerFactory;
    private final LogStream logStream;

    private Set<Path> getFiles(Path scanRoot, LogStream logStream) throws IOException {
        Files.walkFileTree(scanRoot, this.visitor);
        ImmutableSet<Path> files = this.visitor.getFiles();
        Set<String> fileTypes = this.visitor.getFileTypesLookedFor();
        String types = Joiner.on((String)", ").join(fileTypes);
        logStream.log("com.srcclr.evidence.files.collecting", Stage.VULNERABLE_METHODS_SCAN, "Found " + files.size() + " " + types + " files for vulnerable method analysis.");
        return files;
    }

    public SimpleFileMethodScanBatcher(MethodScannerFactory methodScannerFactory, LogStream logStream, StoredFileVisitor visitor) {
        this.methodScannerFactory = methodScannerFactory;
        this.logStream = logStream;
        this.visitor = visitor;
    }

    @Override
    public MethodScanBatcher.Result batch(Path scanRoot, Collection<MethodInfo> methods, Collection<MethodInfo> publicMethodStubs) throws IOException {
        Set<Path> files = this.getFiles(scanRoot, this.logStream);
        MethodScanner scanner = this.methodScannerFactory.withPublicMethodStubs(publicMethodStubs).forFiles(files, methods, this.ENTRY_POINT_RESOLVER);
        Map<MethodInfo, Collection<CallChain>> chains = scanner.scan();
        return new MethodScanBatcher.Result(chains, Collections.singleton(scanner.getCallGraph()));
    }
}

