/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.google.common.collect.Lists;
import com.sourceclear.api.data.methods.CallChainModel;
import com.sourceclear.api.data.methods.CallSiteModel;
import com.sourceclear.api.data.methods.MethodCallData;
import com.sourceclear.api.data.methods.MethodModel;
import com.sourceclear.methods.MethodInfo;
import java.util.ArrayList;
import java.util.Collection;

class MethodUtils {
    static MethodModel getMethodModel(MethodInfo vulnerableMethod) {
        return new MethodModel(vulnerableMethod.getModuleName(), vulnerableMethod.getClassName(), vulnerableMethod.getMethodName(), vulnerableMethod.getDesc());
    }

    static MethodInfo getMethodInfo(MethodModel methodModel) {
        return new MethodInfo(methodModel.getModuleName(), methodModel.getClassName(), methodModel.getMethodName(), methodModel.getDescriptor());
    }

    static Collection<CallSiteModel> findCallChainFrom(MethodModel model, Collection<MethodCallData> inputCallChains) {
        for (MethodCallData methodCallData : inputCallChains) {
            for (CallChainModel callChain : methodCallData) {
                ArrayList callChainList = Lists.newArrayList((Iterable)callChain);
                int foundIndex = -1;
                for (int i = 0; i < callChainList.size(); ++i) {
                    CallSiteModel callSite = (CallSiteModel)callChainList.get(i);
                    if (!callSite.getCaller().equals(model)) continue;
                    foundIndex = i;
                    break;
                }
                if (foundIndex == -1) continue;
                return callChainList.subList(foundIndex, callChainList.size());
            }
        }
        return null;
    }

    private MethodUtils() {
    }
}

