/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.google.common.collect.ImmutableSet;
import com.sourceclear.api.data.methods.CallChainModel;
import com.sourceclear.api.data.methods.CallSiteModel;
import com.sourceclear.api.data.methods.MethodCallData;
import com.sourceclear.api.data.methods.MethodModel;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.methods.MethodScanBatcher;
import com.sourceclear.engine.methods.MethodUtils;
import com.sourceclear.engine.methods.MethodsEngine;
import com.sourceclear.methods.CallChain;
import com.sourceclear.methods.CallGraph;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.MethodInfo;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

abstract class BaseMethodsEngine
implements MethodsEngine {
    private Set<CallGraph> callGraph = new HashSet<CallGraph>();

    BaseMethodsEngine() {
    }

    @Override
    public MethodsEngine withPublicMethodStubs(Collection<MethodInfo> publicMethodStubs) {
        return this;
    }

    @Override
    public Collection<MethodInfo> getPublicMethodStubs() {
        return Collections.emptySet();
    }

    abstract MethodScanBatcher setupBatcher(Path var1, LogStream var2);

    Collection<MethodCallData> innerScanMethods(Path scanRoot, Collection<MethodCallData> inputMethodData, LogStream logStream) throws IOException {
        HashSet<MethodInfo> rootMethods = new HashSet<MethodInfo>();
        HashSet<MethodInfo> scanMethods = new HashSet<MethodInfo>();
        for (MethodCallData methodCallData : inputMethodData) {
            MethodModel vulnerableMethod = methodCallData.getMethod();
            rootMethods.add(MethodUtils.getMethodInfo(vulnerableMethod));
            for (CallChainModel callChainModel : methodCallData) {
                for (CallSiteModel callSite : callChainModel) {
                    MethodModel caller = callSite.getCaller();
                    MethodInfo methodInfo = MethodUtils.getMethodInfo(caller);
                    scanMethods.add(methodInfo);
                }
            }
        }
        scanMethods.addAll(rootMethods);
        if (scanMethods.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashMap<MethodModel, MethodCallData> resultCallData = new LinkedHashMap<MethodModel, MethodCallData>();
        MethodScanBatcher batcher = this.setupBatcher(scanRoot, logStream);
        MethodScanBatcher.Result result = batcher.batch(scanRoot, scanMethods, this.getPublicMethodStubs());
        this.callGraph = result.graph;
        for (Map.Entry entry : result.chains.entrySet()) {
            MethodInfo vulnerableMethod = (MethodInfo)entry.getKey();
            Collection callChains = (Collection)entry.getValue();
            this.processScanResultIntoMap(rootMethods, scanMethods, inputMethodData, resultCallData, vulnerableMethod, callChains);
        }
        return ImmutableSet.copyOf(resultCallData.values());
    }

    private void processScanResultIntoMap(Set<MethodInfo> rootMethods, Set<MethodInfo> scanMethods, Collection<MethodCallData> inputCallChains, Map<MethodModel, MethodCallData> resultCallData, MethodInfo vulnerableMethod, Collection<CallChain> callChains) {
        for (CallChain callChain : callChains) {
            MethodModel targetMethod;
            MethodCallData methodCallData;
            MethodModel lastCallee;
            Collection<CallSiteModel> remainingCallChain;
            CallChainModel callChainModel = new CallChainModel();
            for (CallSite call : callChain) {
                MethodInfo caller = call.getCaller();
                MethodInfo callee = call.getCallee();
                boolean internal = scanMethods.contains(caller);
                MethodModel callerModel = MethodUtils.getMethodModel(caller);
                MethodModel calleeModel = MethodUtils.getMethodModel(callee);
                callChainModel.addCallSite(new CallSiteModel(callerModel, calleeModel, call.getFileName(), call.getLineNumber(), internal));
            }
            if (!rootMethods.contains(vulnerableMethod) && (remainingCallChain = MethodUtils.findCallChainFrom(lastCallee = callChainModel.getTargetMethod(), inputCallChains)) != null) {
                for (CallSiteModel internalCallSite : remainingCallChain) {
                    CallSiteModel callSiteModel = new CallSiteModel(internalCallSite.getCaller(), internalCallSite.getCallee(), internalCallSite.getFileName(), internalCallSite.getLineNumber(), true);
                    callChainModel.addCallSite(callSiteModel);
                }
            }
            if ((methodCallData = resultCallData.get(targetMethod = callChainModel.getTargetMethod())) == null) {
                methodCallData = new MethodCallData(targetMethod);
                resultCallData.put(targetMethod, methodCallData);
            }
            methodCallData.addCallChain(callChainModel);
        }
    }

    @Override
    public Set<CallGraph> getCallGraph() {
        return this.callGraph;
    }
}

