/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.yarn;

import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.NPMNativeCollector;
import com.sourceclear.engine.component.natives.parsing.JsonFileParser;
import com.sourceclear.engine.component.natives.parsing.NPMPackage;
import com.sourceclear.engine.component.natives.parsing.PackageDotJson;
import com.sourceclear.engine.component.yarn.YarnLockFile;
import com.sourceclear.engine.component.yarn.YarnLockParser;
import com.sourceclear.engine.component.yarn.YarnPackage;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractYarnCollector {
    public static final String YARNLOCK_FILENAME = "yarn.lock";
    protected static final String PACKAGE_JSON_FILENAME = "package.json";

    public YarnLockFile getYarnLockFile(File projectRoot) throws CollectionException {
        return YarnLockParser.parse(projectRoot.toPath().resolve(YARNLOCK_FILENAME).toFile());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PackageDotJson getPackageDotJson(File projectRoot) throws CollectionException {
        File packageDotJsonFile = projectRoot.toPath().resolve(PACKAGE_JSON_FILENAME).toFile();
        try (FileInputStream inputStream = new FileInputStream(packageDotJsonFile);){
            PackageDotJson packageDotJson = JsonFileParser.parsePackageDotJson(inputStream);
            return packageDotJson;
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.", e.getMessage()).initCause(e);
        }
    }

    protected LibraryGraphContainer buildGraph(ImmutableMap<String, Object> attributes, LibraryGraph.Builder builder, PackageDotJson packageDotJson, YarnLockFile yarnLockFile) {
        NPMNativeCollector.Scope declaredScope = NPMNativeCollector.scope(attributes);
        if (declaredScope == NPMNativeCollector.Scope.NONE || declaredScope == NPMNativeCollector.Scope.PRODUCTION) {
            this.addToGraphBuilderForDependencies(builder, packageDotJson.getDependencies(), yarnLockFile.getYarnPackages(), new HashSet<String>());
            this.addToGraphBuilderForDependencies(builder, packageDotJson.getOptionalDependencies(), yarnLockFile.getYarnPackages(), new HashSet<String>());
            this.addToGraphBuilderForDependencies(builder, packageDotJson.getPeerDependencies(), yarnLockFile.getYarnPackages(), new HashSet<String>());
        }
        if (declaredScope == NPMNativeCollector.Scope.NONE || declaredScope == NPMNativeCollector.Scope.DEVELOPMENT) {
            this.addToGraphBuilderForDependencies(builder, packageDotJson.getDevDependencies(), yarnLockFile.getYarnPackages(), new HashSet<String>());
        }
        return new LibraryGraphContainer.Builder().withGraph(builder.build()).build();
    }

    private void addToGraphBuilderForDependencies(LibraryGraph.Builder builder, List<NPMPackage> dependencies, Map<String, YarnPackage> packages, Set<String> discovered) {
        dependencies.stream().map(dependency -> {
            String fullDeclaration = YarnPackage.getFullDeclaration(dependency.getName(), dependency.getVersionDeclared());
            return this.depToGraph(fullDeclaration, packages, discovered);
        }).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((LibraryGraph.Builder)builder).withDirect(arg_0));
    }

    private Optional<LibraryGraph> depToGraph(String pkgFullDeclaration, Map<String, YarnPackage> packages, Set<String> discovered) {
        LibraryGraph.Builder builder = new LibraryGraph.Builder();
        YarnPackage yarnPackage = packages.get(pkgFullDeclaration);
        if (yarnPackage == null) {
            return Optional.empty();
        }
        if (discovered.contains(pkgFullDeclaration)) {
            return Optional.empty();
        }
        discovered.add(pkgFullDeclaration);
        String version = yarnPackage.getVersion();
        if (StringUtils.isBlank((CharSequence)version)) {
            return Optional.empty();
        }
        Coords coords = new Coords.Builder().withCoordinate1(YarnPackage.getPackageNameFromFullDeclaration(pkgFullDeclaration)).withCoordinateType(CoordinateType.NPM).withVersion(version).build();
        this.addToGraphBuilderForDependencies(builder, yarnPackage.getDependencies(), packages, discovered);
        this.addToGraphBuilderForDependencies(builder, yarnPackage.getOptionalDependencies(), packages, discovered);
        this.addToGraphBuilderForDependencies(builder, yarnPackage.getPeerDependencies(), packages, discovered);
        this.addToGraphBuilderForDependencies(builder, yarnPackage.getDevDependencies(), packages, discovered);
        discovered.remove(pkgFullDeclaration);
        builder.withCoords(coords).withFilename(YARNLOCK_FILENAME);
        return Optional.of(builder.build());
    }
}

