/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.quickscancollectors;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.natives.parsing.PackageDotJson;
import com.sourceclear.engine.component.quickscancollectors.QuickscanCollector;
import com.sourceclear.engine.component.yarn.AbstractYarnCollector;
import com.sourceclear.engine.component.yarn.YarnLockFile;
import com.sourceclear.engine.component.yarn.YarnLockParser;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YarnDotLockQuickscanCollector
extends AbstractYarnCollector
implements QuickscanCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(YarnDotLockQuickscanCollector.class);
    private final LogStream logStream;

    public YarnDotLockQuickscanCollector(LogStream logStream) {
        this.logStream = logStream;
    }

    @Override
    @Nonnull
    public String getName() {
        return "Yarn Quickscan";
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File scanTarget, ImmutableMap<String, Object> attributes) throws CollectionException {
        File yarnDotLockFile;
        File file = yarnDotLockFile = scanTarget.isDirectory() ? new File(scanTarget, "yarn.lock") : scanTarget;
        if (!yarnDotLockFile.canRead()) {
            throw new CollectionException(CollectionErrorType.IO, String.format("Cannot read %s, please ensure it exists", scanTarget));
        }
        YarnLockFile yarnLockFile = YarnLockParser.parseCustom(yarnDotLockFile);
        PackageDotJson packageDotJson = null;
        try {
            packageDotJson = this.getPackageDotJson(scanTarget.isDirectory() ? scanTarget : scanTarget.getParentFile());
        }
        catch (CollectionException ex) {
            this.logStream.log("com.srcclr.evidence.issue", Stage.EVIDENCE_COLLECTION, "No package.json found.");
            throw ex;
        }
        String name = packageDotJson.getName();
        String version = packageDotJson.getVersion();
        LibraryGraph.Builder builder = new LibraryGraph.Builder().withFilename("yarn.lock");
        if (StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)version)) {
            Coords coords = new Coords.Builder().withCoordinateType(CoordinateType.NPM).withCoordinate1(name).withVersion(version).build();
            builder.withCoords(coords);
        }
        return this.buildGraph(attributes, builder, packageDotJson, yarnLockFile);
    }

    @Override
    public boolean supports(File file) {
        if (file.isFile()) {
            return file.getName().equalsIgnoreCase("yarn.lock");
        }
        if (file.isDirectory()) {
            HashSet<String> children = new HashSet<String>(Arrays.asList(file.list()));
            return children.containsAll(Lists.newArrayList((Object[])new String[]{"package.json", "yarn.lock"}));
        }
        return false;
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).setBuildCommandType(BuildCommandType.NOT_NEEDED).build();
    }
}

