/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.quickscancollectors;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.pipenv.PipfileDotLock;
import com.sourceclear.engine.component.quickscancollectors.QuickscanCollector;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class PipfileLockQuickscanCollector
implements QuickscanCollector {
    private Path lockfile;

    private static Coords toCoords(String name, PipfileDotLock.PipPackageDetails pipPackageDetails) {
        return new Coords.Builder().withCoordinateType(CoordinateType.PYPI).withCoordinate1(name).withVersion(pipPackageDetails.getVersion()).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PipfileDotLock getPipfileDotLock(Path filepath) throws CollectionException {
        try (InputStream inputStream = Files.newInputStream(filepath, new OpenOption[0]);){
            PipfileDotLock pipfileDotLock = PipfileDotLock.parse(inputStream);
            return pipfileDotLock;
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, e.getMessage()).initCause(e);
        }
    }

    private static LibraryGraphContainer getGraph(Path lockfile) throws CollectionException {
        PipfileDotLock pipfileDotLock = PipfileLockQuickscanCollector.getPipfileDotLock(lockfile);
        Map<String, PipfileDotLock.PipPackageDetails> defaultPackages = pipfileDotLock.getDefaultPackages();
        Map<String, PipfileDotLock.PipPackageDetails> developPackages = pipfileDotLock.getDevelopPackages();
        String filename = lockfile.getFileName().toString();
        HashSet<LibraryGraph> directs = new HashSet<LibraryGraph>();
        directs.addAll(PipfileLockQuickscanCollector.directsFrom(defaultPackages, filename));
        directs.addAll(PipfileLockQuickscanCollector.directsFrom(developPackages, filename));
        LibraryGraph root = new LibraryGraph.Builder().withFilename(filename).withDirects(directs).build();
        return new LibraryGraphContainer.Builder().withGraph(root).build();
    }

    @Override
    @Nonnull
    public String getName() {
        return "Pipfile.lock quickscan";
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File scanTarget, ImmutableMap<String, Object> attributes) throws CollectionException {
        if (this.lockfile == null) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, String.format("'%s' does not support this project but evidence collection was attempted.", this.getName()));
        }
        return PipfileLockQuickscanCollector.getGraph(this.lockfile);
    }

    @Override
    public boolean supports(File file) {
        Optional<Path> lockfilePath = CollectorUtils.isOrContainFile(file.toPath(), "Pipfile.lock");
        this.lockfile = lockfilePath.isPresent() ? (Path)lockfilePath.get() : null;
        return lockfilePath.isPresent();
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).setBuildCommandType(BuildCommandType.NOT_NEEDED).build();
    }

    private static Set<LibraryGraph> directsFrom(Map<String, PipfileDotLock.PipPackageDetails> packagesMap, String filename) {
        HashSet<LibraryGraph> directs = new HashSet<LibraryGraph>(packagesMap.size());
        for (Map.Entry<String, PipfileDotLock.PipPackageDetails> entry : packagesMap.entrySet()) {
            String packageName = entry.getKey();
            PipfileDotLock.PipPackageDetails pipPackageDetails = entry.getValue();
            directs.add(new LibraryGraph.Builder().withFilename(filename).withCoords(PipfileLockQuickscanCollector.toCoords(packageName, pipPackageDetails)).withLineNumber(Integer.valueOf(pipPackageDetails.getLineNumber())).build());
        }
        return directs;
    }
}

