/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.quickscancollectors;

import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.golang.GoPackage;
import com.sourceclear.engine.component.golang.GovendorJson;
import com.sourceclear.engine.component.quickscancollectors.GoQuickscanCollector;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class GovendorQuickscanCollector
extends GoQuickscanCollector {
    @Override
    @Nonnull
    public String getName() {
        return "Govendor quickscan";
    }

    @Override
    @Nonnull
    String lockDir() {
        return "vendor";
    }

    @Override
    @Nonnull
    String lockFile() {
        return "vendor.json";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    List<GoPackage> dependencies(Path lockfile) throws CollectionException {
        try (InputStream inputStream = Files.newInputStream(lockfile, new OpenOption[0]);){
            GovendorJson govendorJson = GovendorJson.parse(inputStream);
            List<GoPackage> goPackages = govendorJson.getImports();
            ArrayList<GoPackage> remove = new ArrayList<GoPackage>();
            for (GoPackage goPackage : goPackages) {
                if (!StringUtils.isBlank((CharSequence)goPackage.getRevision())) continue;
                remove.add(goPackage);
            }
            goPackages.removeAll(remove);
            List<GoPackage> list = goPackages;
            return list;
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, e.getMessage()).initCause(e);
        }
    }
}

