/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.natives.parsing;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.engine.component.natives.parsing.NPMPackage;
import com.sourceclear.engine.component.natives.parsing.NPMPackageListDeserializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BowerJson {
    @JsonProperty
    private String name;
    @JsonProperty
    @JsonDeserialize(using=NPMPackageListDeserializer.class)
    private List<NPMPackage> dependencies = new ArrayList<NPMPackage>();
    @JsonProperty
    @JsonDeserialize(using=NPMPackageListDeserializer.class)
    private List<NPMPackage> devDependencies = new ArrayList<NPMPackage>();

    BowerJson() {
    }

    @VisibleForTesting
    BowerJson(String name, List<NPMPackage> dependencies, List<NPMPackage> devDependencies) {
        this.name = name;
        this.dependencies = dependencies;
        this.devDependencies = devDependencies;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BowerJson bowerJson = (BowerJson)o;
        return Objects.equals(this.name, bowerJson.name) && Objects.equals(this.dependencies, bowerJson.dependencies) && Objects.equals(this.devDependencies, bowerJson.devDependencies);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dependencies, this.devDependencies);
    }

    public String toString() {
        return "BowerJson{name='" + this.name + '\'' + ", dependencies=" + this.dependencies + ", devDependencies=" + this.devDependencies + '}';
    }

    public String getName() {
        return this.name;
    }

    public List<NPMPackage> getDependencies() {
        return this.dependencies;
    }

    public List<NPMPackage> getDevDependencies() {
        return this.devDependencies;
    }
}

