/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.gem;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.sourceclear.api.data.evidence.CoordinateType;
import com.sourceclear.api.data.evidence.Coordinates;
import com.sourceclear.engine.component.gem.GemSpec;
import com.sourceclear.engine.component.gem.GemfileDotLock;
import com.sourceclear.engine.component.gem.Source;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class GemfileDotLockParser {
    private static final Pattern GEM_SPEC_PATTERN = Pattern.compile("(?<name>[\\.\\_\\-\\w]+)\\s?(?:\\((?<version>.+?)\\))?");
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("(?<name>[._\\-\\w]+)!?\\s?(?:\\((?<version>.+?)\\))?!?");
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GemfileDotLockParser.class.getName());
    private static final String SIX_SPACES = "      ";
    private static final String TWO_SPACES = "  ";
    private static final String FOUR_SPACES = "    ";
    private final Map<String, Endpoint> endpoints = Maps.newHashMap();
    private final String contents;
    private Mode currentMode = Mode.START;
    private Source.Builder sourceBuilder = null;
    private final GemfileDotLock.Builder builder = new GemfileDotLock.Builder();
    private GemSpec.Builder gemSpecBuilder;

    public GemfileDotLockParser(String contents) {
        this.contents = contents;
        this.endpoints.put(this.formatKey(Mode.START, Indentation.NONE), new TopLevel());
        this.endpoints.put(this.formatKey(Mode.SOURCE, Indentation.TWO), new SourceHeader());
        this.endpoints.put(this.formatKey(Mode.SOURCE, Indentation.FOUR), new SourceItem());
        this.endpoints.put(this.formatKey(Mode.SOURCE, Indentation.SIX), new SourceSubItem());
        this.endpoints.put(this.formatKey(Mode.SOURCE, Indentation.NONE), new TopLevel());
        this.endpoints.put(this.formatKey(Mode.PLATFORMS, Indentation.TWO), new PlatformItem());
        this.endpoints.put(this.formatKey(Mode.PLATFORMS, Indentation.NONE), new TopLevel());
        this.endpoints.put(this.formatKey(Mode.DEPENDENCIES, Indentation.TWO), new DependencyItem());
        this.endpoints.put(this.formatKey(Mode.DEPENDENCIES, Indentation.NONE), new TopLevel());
        this.endpoints.put(this.formatKey(Mode.BUNDLED_WITH, Indentation.TWO), new BundledWithItem());
    }

    public GemfileDotLock getLockFile() {
        this.closeGemSpecBuilder();
        this.addSource();
        return this.builder.build();
    }

    public void parse() throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(this.contents));
        int lineNumber = 1;
        String line = reader.readLine();
        while (line != null) {
            Indentation i = Indentation.NONE;
            if (line.startsWith(SIX_SPACES)) {
                i = Indentation.SIX;
            } else if (line.startsWith(FOUR_SPACES)) {
                i = Indentation.FOUR;
            } else if (line.startsWith(TWO_SPACES)) {
                i = Indentation.TWO;
            }
            Endpoint e = this.endpoints.get(this.formatKey(this.currentMode, i));
            if (e != null) {
                e.exec(line.trim(), lineNumber);
            } else {
                LOGGER.debug("Couldn't find endpoint for mode " + this.formatKey(this.currentMode, i));
            }
            ++lineNumber;
            line = reader.readLine();
        }
    }

    private void closeGemSpecBuilder() {
        if (this.gemSpecBuilder != null && this.sourceBuilder != null) {
            this.sourceBuilder.withGem(this.gemSpecBuilder.build());
            this.gemSpecBuilder = null;
        }
    }

    private void addSource() {
        if (this.sourceBuilder != null) {
            this.closeGemSpecBuilder();
            this.builder.withSource(this.sourceBuilder.build());
            this.sourceBuilder = null;
        }
    }

    private String formatKey(Mode m, Indentation i) {
        return String.format("%s:%s", new Object[]{m.toString().replace("_", " "), i});
    }

    private class BundledWithItem
    implements Endpoint {
        private BundledWithItem() {
        }

        @Override
        public void exec(String value, Integer lineNumber) {
            LOGGER.trace("Found " + value);
        }
    }

    private class DependencyItem
    implements Endpoint {
        private DependencyItem() {
        }

        @Override
        public void exec(String value, Integer lineNumber) {
            Matcher m = DEPENDENCY_PATTERN.matcher(value);
            if (m.matches()) {
                LOGGER.trace("Adding depdendency " + value);
                GemfileDotLockParser.this.builder.withDependencies(new Coordinates.Builder().withCoordinateType(CoordinateType.GEM).withCoordinate1(m.group("name")).withVersion(m.group("version")).build(), lineNumber);
            } else {
                LOGGER.debug("Could not match input " + value);
            }
        }
    }

    private class PlatformItem
    implements Endpoint {
        private PlatformItem() {
        }

        @Override
        public void exec(String value, Integer lineNumber) {
            GemfileDotLockParser.this.builder.withPlatform(value);
        }
    }

    private class SourceSubItem
    implements Endpoint {
        private SourceSubItem() {
        }

        @Override
        public void exec(String value, Integer lineNumber) {
            Matcher m = GEM_SPEC_PATTERN.matcher(value);
            if (m.matches()) {
                GemfileDotLockParser.this.gemSpecBuilder.withTransitive(new Coordinates.Builder().withCoordinateType(CoordinateType.GEM).withCoordinate1(m.group("name")).withVersion(m.group("version")).build());
            } else {
                LOGGER.debug("Could not match input " + value);
            }
        }
    }

    private class SourceItem
    implements Endpoint {
        private SourceItem() {
        }

        @Override
        public void exec(String value, Integer lineNumber) {
            GemfileDotLockParser.this.closeGemSpecBuilder();
            Matcher m = GEM_SPEC_PATTERN.matcher(value);
            if (m.matches()) {
                LOGGER.debug("Preparing a new GemSpec for " + value);
                GemfileDotLockParser.this.gemSpecBuilder = new GemSpec.Builder();
                GemfileDotLockParser.this.gemSpecBuilder.withCoordinates(new Coordinates.Builder().withCoordinateType(CoordinateType.GEM).withCoordinate1(m.group("name")).withVersion(m.group("version")).build()).withLineNumber(lineNumber);
            } else {
                LOGGER.debug("Could not match value " + value);
            }
        }
    }

    private class SourceHeader
    implements Endpoint {
        private SourceHeader() {
        }

        @Override
        public void exec(String value, Integer lineNumber) {
            if (value.startsWith("remote")) {
                String remote = value.replace("remote:", "").trim();
                GemfileDotLockParser.this.sourceBuilder.withRemote(remote);
                LOGGER.debug("Setting remote to " + remote);
            } else if (value.startsWith("specs")) {
                LOGGER.debug("Ready for specs section");
            } else {
                LOGGER.debug("Unknown line: " + value);
            }
        }
    }

    private class TopLevel
    implements Endpoint {
        private TopLevel() {
        }

        @Override
        public void exec(String value, Integer lineNumber) {
            if (Strings.isNullOrEmpty((String)value)) {
                return;
            }
            GemfileDotLockParser.this.addSource();
            switch (value) {
                case "GEM": 
                case "PATH": 
                case "GIT": {
                    LOGGER.debug("Entering the {} source section.", (Object)value);
                    GemfileDotLockParser.this.currentMode = Mode.SOURCE;
                    GemfileDotLockParser.this.sourceBuilder = new Source.Builder();
                    break;
                }
                case "PLATFORMS": {
                    LOGGER.debug("Entering the PLATFORMS section.");
                    GemfileDotLockParser.this.currentMode = Mode.PLATFORMS;
                    break;
                }
                case "DEPENDENCIES": {
                    LOGGER.debug("Entering the DEPENDENCIES section.");
                    GemfileDotLockParser.this.currentMode = Mode.DEPENDENCIES;
                    break;
                }
                case "BUNDLED WITH": {
                    LOGGER.debug("Entering the BUNDLED WITH section.");
                    GemfileDotLockParser.this.currentMode = Mode.BUNDLED_WITH;
                    break;
                }
                default: {
                    LOGGER.debug("Ignoring unknown section: {}", (Object)value);
                }
            }
        }
    }

    private static interface Endpoint {
        public void exec(String var1, Integer var2);
    }

    private static enum Indentation {
        NONE,
        TWO,
        FOUR,
        SIX;

    }

    private static enum Mode {
        START,
        SOURCE,
        PLATFORMS,
        DEPENDENCIES,
        BUNDLED_WITH;

    }
}

