/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.FeatureFlag;
import com.sourceclear.engine.common.SOFileVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.sourceclear.engine.component.linuxso.SOFileAnalyzer;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MakefileNativeCollector
implements NativeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(MakefileNativeCollector.class);
    private static final String MAKE = "make";
    private static final List<String> MAKEFILE_NAMES = Lists.newArrayList((Object[])new String[]{"GNUmakefile", "makefile", "Makefile"});
    private static final String DEFAULT_BUILD_TARGET = "";
    private static final String DEFAULT_CLEAN_TARGET = "clean";
    private static final Path LD_SO_CONF_FILEPATH = Paths.get("/etc/ld.so.conf", new String[0]);
    static final Pattern INCLUDE_NAME_PATTERN = Pattern.compile("\\s+-I\\s*((\\\\[\"\\s]|[^\"\\s])+|\"(\\\\\"|[^\"])+\")");
    static final Pattern LIB_DIRECTORY_PATTERN = Pattern.compile("\\s+-L\\s*((\\\\[\"\\s]|[^\"\\s])+|\"(\\\\\"|[^\"])+\")");
    static final Pattern LIB_NAME_PATTERN = Pattern.compile("\\s+-l\\s*((\\\\[\"\\s]|[^\"\\s])+|\"(\\\\\"|[^\"])+\")");
    private static final String LINUX_SHARED_LIB_EXT = ".so";
    private static final String LD_LIBRARY_PATH = "LD_LIBRARY_PATH";
    private final LogStream logStream;
    private final ImmutableMap<String, Object> attributes;
    private File makeBin;
    private String makeFile;

    public MakefileNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        this.logStream = logStream;
        this.attributes = attributes;
    }

    @Override
    public String getName() {
        return "Makefile";
    }

    @Override
    public boolean supports(File projectPath) {
        if (!FeatureFlag.featureIsOn(FeatureFlag.Flag.ENABLE_CPP, this.attributes)) {
            return false;
        }
        return this.checkMakefileExists(projectPath);
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(MAKEFILE_NAMES);
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        if (!SystemUtils.IS_OS_LINUX) {
            LOGGER.debug("Scanning C++ projects is not supported on this OS.");
            return false;
        }
        try {
            this.makeBin = CollectorUtils.resolveExeOrThrow(MAKE);
            return true;
        }
        catch (CollectionException ex) {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, ex.getMessage());
            return false;
        }
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        return false;
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        if (this.makeBin == null) {
            throw new RuntimeException("makeBin is null. Ensure that systemIsReady() is called and makeBin is set.");
        }
        if (this.makeFile == null) {
            throw new RuntimeException("makeFile is null. Ensure that supports() is called and makeFile is set.");
        }
        LOGGER.debug("makeBin: {}, makeFile: {}", (Object)this.makeBin, (Object)this.makeFile);
        LibraryGraph.Builder rootGraphBuilder = new LibraryGraph.Builder();
        HashSet<LibraryGraph> librariesLinked = new HashSet<LibraryGraph>();
        rootGraphBuilder.withFilename(this.makeFile);
        List<String> makeOutput = this.buildProject(projectRoot.toPath());
        LOGGER.debug("Got make output.");
        ImmutableSet<Path> soFilesFound = this.searchSOFilesInProjectRoot(projectRoot.toPath());
        for (Path soFile : soFilesFound) {
            librariesLinked.add(SOFileAnalyzer.analyze(soFile, projectRoot.toPath().relativize(soFile).toString()));
        }
        LOGGER.debug("Num .so libraries found from searching projectRoot: {}", (Object)librariesLinked.size());
        CompilerOptions compilerOptions = MakefileNativeCollector.parseMakeOutputForCompilerOptions(makeOutput, projectRoot.toPath());
        LOGGER.debug("Done parsing make output for compiler options.");
        compilerOptions.libraryDirectories.addAll(MakefileNativeCollector.getLinkerPaths());
        compilerOptions.libraryDirectories.addAll(MakefileNativeCollector.getLDLibraryPaths());
        LOGGER.debug("compilerOptions with linkerPaths and LDLibraryPaths: {}", (Object)compilerOptions);
        Set<String> libraryNamesNotFound = this.getMissingLibraryNames(soFilesFound, compilerOptions.libraryNames);
        LOGGER.debug("Names found in make output but not in project directory: {}", libraryNamesNotFound);
        Set<LibraryGraph> libraryGraphs = this.tryGetSOFileLibraryGraphs(projectRoot, compilerOptions.libraryDirectories, libraryNamesNotFound);
        librariesLinked.addAll(libraryGraphs);
        LOGGER.debug("Final number of .so libraries found: {}", (Object)librariesLinked.size());
        rootGraphBuilder.withDirects(librariesLinked);
        return new LibraryGraphContainer.Builder().withGraph(rootGraphBuilder.build()).build();
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).build();
    }

    static CompilerOptions parseMakeOutputForCompilerOptions(List<String> makeOutput, Path projectPath) {
        CompilerOptions compilerOptions = new CompilerOptions();
        for (String line : makeOutput) {
            Set<String> includePaths = MakefileNativeCollector.extractPathsFromOptions(INCLUDE_NAME_PATTERN, line);
            for (String includePath : includePaths) {
                compilerOptions.includeDirectories.add(projectPath.resolve(includePath).normalize());
            }
            Set<String> libraryPaths = MakefileNativeCollector.extractPathsFromOptions(LIB_DIRECTORY_PATTERN, line);
            for (String libraryPath : libraryPaths) {
                compilerOptions.libraryDirectories.add(projectPath.resolve(libraryPath).normalize());
            }
            compilerOptions.libraryNames.addAll(MakefileNativeCollector.extractPathsFromOptions(LIB_NAME_PATTERN, line));
        }
        return compilerOptions;
    }

    static Set<String> extractPathsFromOptions(Pattern pattern, String input) {
        LinkedHashSet<String> extractedPaths = new LinkedHashSet<String>();
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            String match = matcher.group(1).trim();
            if (match.startsWith("\"")) {
                match = match.substring(1);
            }
            if (match.endsWith("\"")) {
                match = match.substring(0, match.length() - 1);
            }
            extractedPaths.add(match.trim());
        }
        return extractedPaths;
    }

    private Set<LibraryGraph> tryGetSOFileLibraryGraphs(File projectRoot, Set<Path> libraryDirectories, Set<String> libraryNames) throws CollectionException {
        Path projectRootPath = projectRoot.toPath();
        HashSet<LibraryGraph> libraryGraphs = new HashSet<LibraryGraph>();
        try {
            block2: for (String libraryName : libraryNames) {
                String libraryNameWithExt = libraryName + LINUX_SHARED_LIB_EXT;
                for (Path directory : libraryDirectories) {
                    Path libraryPath = directory.resolve("lib" + libraryNameWithExt);
                    if (!Files.exists(libraryPath, new LinkOption[0]) || !SOFileVisitor.isELF(libraryPath)) continue;
                    libraryGraphs.add(SOFileAnalyzer.analyze(libraryPath.toRealPath(new LinkOption[0]), projectRootPath.relativize(libraryPath).toString()));
                    continue block2;
                }
            }
        }
        catch (IOException ex) {
            throw new CollectionException(CollectionErrorType.IO, "An error occurred when resolving library paths.", ex.getMessage()).initCause(ex);
        }
        return libraryGraphs;
    }

    private Set<String> getMissingLibraryNames(ImmutableSet<Path> filesFound, Set<String> names) {
        HashSet<String> namesFound = new HashSet<String>();
        for (Path path : filesFound) {
            namesFound.add(path.getFileName().toString());
        }
        return Sets.difference(names, namesFound);
    }

    private static Set<Path> getLinkerPaths() throws CollectionException {
        LinkedHashSet<Path> pathsFound = new LinkedHashSet<Path>();
        ArrayList<Path> configFiles = new ArrayList<Path>();
        configFiles.add(LD_SO_CONF_FILEPATH);
        while (!configFiles.isEmpty()) {
            Path current = (Path)configFiles.remove(0);
            if (!Files.exists(current, new LinkOption[0])) continue;
            try {
                InputStream inputStream = Files.newInputStream(current, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    List fileContents = IOUtils.readLines((InputStream)inputStream, (Charset)Charset.defaultCharset());
                    for (String line : fileContents) {
                        if (StringUtils.isBlank((CharSequence)(line = line.trim()))) continue;
                        if (line.startsWith("include ")) {
                            Path includePath = Paths.get(line.replaceFirst("include ", DEFAULT_BUILD_TARGET).trim(), new String[0]);
                            DirectoryStream<Path> pathDirectoryStream = Files.newDirectoryStream(current.getParent().resolve(includePath.getParent()), includePath.getFileName().toString());
                            Throwable throwable2 = null;
                            try {
                                for (Path path : pathDirectoryStream) {
                                    configFiles.add(path);
                                }
                                continue;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (pathDirectoryStream == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        pathDirectoryStream.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue;
                                }
                                pathDirectoryStream.close();
                                continue;
                            }
                        }
                        if (line.startsWith("#")) continue;
                        pathsFound.add(Paths.get(line, new String[0]));
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException ex) {
                throw new CollectionException(CollectionErrorType.IO, "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.", ex.getMessage()).initCause(ex);
            }
        }
        return pathsFound;
    }

    private static Set<Path> getLDLibraryPaths() {
        LinkedHashSet<Path> pathsFound = new LinkedHashSet<Path>();
        String ldLibraryPathValue = System.getenv(LD_LIBRARY_PATH);
        if (StringUtils.isNotBlank((CharSequence)ldLibraryPathValue)) {
            String[] values;
            for (String value : values = ldLibraryPathValue.split(";")) {
                pathsFound.add(Paths.get(value, new String[0]));
            }
        }
        return pathsFound;
    }

    private List<String> buildProject(Path projectRoot) throws CollectionException {
        List<String> makeOutput;
        block16: {
            String userMakeOutputFile;
            String buildTarget = (String)MakefileNativeCollector.getOrDefault(this.attributes, "MAKE_BUILD_TARGET", DEFAULT_BUILD_TARGET);
            String cleanTarget = (String)MakefileNativeCollector.getOrDefault(this.attributes, "MAKE_CLEAN_TARGET", DEFAULT_CLEAN_TARGET);
            LOGGER.debug("buildTarget: {}, cleanTarget: {}", (Object)buildTarget, (Object)cleanTarget);
            ArrayList cleanCommand = Lists.newArrayList((Object[])new String[]{this.makeBin.getAbsolutePath(), cleanTarget});
            ArrayList buildCommand = Lists.newArrayList((Object[])new String[]{this.makeBin.getAbsolutePath()});
            if (StringUtils.isNotBlank((CharSequence)buildTarget)) {
                buildCommand.add(buildTarget);
            }
            if (StringUtils.isNotBlank((CharSequence)(userMakeOutputFile = (String)MakefileNativeCollector.getOrDefault(this.attributes, "MAKE_OUTPUT_FILE", DEFAULT_BUILD_TARGET)))) {
                try (InputStream inputStream = Files.newInputStream(projectRoot.resolve(userMakeOutputFile), new OpenOption[0]);){
                    makeOutput = IOUtils.readLines((InputStream)inputStream, (Charset)Charset.defaultCharset());
                    break block16;
                }
                catch (IOException ex) {
                    throw new CollectionException(CollectionErrorType.IO, "Unable to read '" + userMakeOutputFile + "' for make output.", ex.getMessage()).initCause(ex);
                }
            }
            CollectorUtils.launchProcess(cleanCommand, projectRoot.toFile(), null, LOGGER);
            HashMap<String, String> buildEnvVars = new HashMap<String, String>();
            buildEnvVars.put("VERBOSE", "1");
            buildEnvVars.put("V", "1");
            makeOutput = CollectorUtils.launchProcess(buildCommand, projectRoot.toFile(), buildEnvVars, LOGGER);
        }
        LOGGER.debug("Finished building project.");
        return makeOutput;
    }

    private ImmutableSet<Path> searchSOFilesInProjectRoot(Path projectRoot) throws CollectionException {
        LOGGER.debug("Searching {} for .so files to analyze.", (Object)projectRoot);
        SOFileVisitor soFileVisitor = new SOFileVisitor(new HashSet<String>(), LOGGER);
        try {
            Files.walkFileTree(projectRoot, soFileVisitor);
        }
        catch (IOException ex) {
            throw new CollectionException(CollectionErrorType.IO, "An IOException occurred while searching projectRoot for .so files.\nRun with --debug to print the stacktrace.").initCause(ex);
        }
        return soFileVisitor.getFiles();
    }

    private boolean checkMakefileExists(File projectPath) {
        for (String makefileName : MAKEFILE_NAMES) {
            if (!Files.exists(projectPath.toPath().resolve(makefileName), new LinkOption[0])) continue;
            this.makeFile = makefileName;
            return true;
        }
        return false;
    }

    private static Object getOrDefault(ImmutableMap<String, Object> attributes, String key, Object defaultValue) {
        return attributes.containsKey((Object)key) ? attributes.get((Object)key) : defaultValue;
    }

    static class CompilerOptions {
        final Set<Path> includeDirectories = new LinkedHashSet<Path>();
        final Set<Path> libraryDirectories = new LinkedHashSet<Path>();
        final Set<String> libraryNames = new HashSet<String>();

        CompilerOptions() {
        }

        public String toString() {
            return "CompilerOptions{includeDirectories=" + this.includeDirectories + ", libraryDirectories=" + this.libraryDirectories + ", libraryNames=" + this.libraryNames + '}';
        }
    }
}

