/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.engine.common.ClassFileVisitor;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.JarUtils;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarNativeCollector
implements NativeCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarNativeCollector.class);
    private final LogStream logStream;
    private final boolean shallow;
    private String previouslyCheckedProjectPath = null;
    private Boolean supportPreviouslyCheckedProjectPath = null;

    public JarNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        this(logStream, attributes, false);
    }

    public JarNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes, boolean shallow) {
        this.logStream = logStream;
        this.shallow = shallow;
    }

    @Override
    public String getName() {
        return "Jar";
    }

    @Override
    public boolean supports(File projectPath) {
        try {
            if (projectPath.canRead()) {
                boolean gotJar = JarUtils.containsJarFile(projectPath, new HashSet<String>());
                this.previouslyCheckedProjectPath = projectPath.getAbsolutePath();
                this.supportPreviouslyCheckedProjectPath = gotJar;
                return gotJar;
            }
        }
        catch (CollectionException e) {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, "Error while checking whether JarNativeCollector supports project: " + e.getMessage());
        }
        this.previouslyCheckedProjectPath = projectPath.getAbsolutePath();
        this.supportPreviouslyCheckedProjectPath = false;
        return false;
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return Sets.newHashSet((Object[])new Pattern[]{Pattern.compile(".+\\.jar")});
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        if (projectDir.getAbsolutePath().equalsIgnoreCase(this.previouslyCheckedProjectPath)) {
            return this.supportPreviouslyCheckedProjectPath;
        }
        return this.supports(projectDir);
    }

    @Override
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        if (this.shallow) {
            return JarUtils.collectSingleFolder(projectRoot, this.logStream);
        }
        return JarUtils.collect(projectRoot, this.logStream);
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        try {
            FileTypeVisitor visitor = ClassFileVisitor.getVisitor();
            Files.walkFileTree(Paths.get(projectRoot.getCanonicalPath(), new String[0]), visitor);
            return !visitor.getFiles().isEmpty();
        }
        catch (Exception ex) {
            this.logStream.log("com.srcclr.evidence.info", Stage.EVIDENCE_COLLECTION, "Unable to determine vulnerable methods support, skipping.");
            LOGGER.error("Couldn't scan for class files in JarNativeCollector.", (Throwable)ex);
            return false;
        }
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).setBuildCommandType(BuildCommandType.NOT_NEEDED).build();
    }
}

