/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.Utils;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.GoPackageManagerCollector;
import com.sourceclear.engine.component.golang.GoDependencyGraph;
import com.sourceclear.engine.component.golang.GoPackage;
import com.sourceclear.engine.component.golang.GovendorJson;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class GovendorNativeCollector
extends GoPackageManagerCollector {
    public static final String VENDOR_FOLDER = "vendor";
    public static final String VENDOR_JSON_FILENAME = "vendor.json";
    private static final String VENDOR_JSON = FilenameUtils.concat((String)"vendor", (String)"vendor.json");
    private static final String GOVENDOR = "govendor";
    private GovendorJson govendorJson = new GovendorJson();

    public GovendorNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        super(logStream, attributes);
    }

    @Override
    public String getName() {
        return "Govendor";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<GoPackage> getResolvedImports(File projectRoot, GoDependencyGraph goDependencyGraph, List<String> goPaths) throws CollectionException {
        File dependencyFile = new File(projectRoot, VENDOR_JSON);
        try (InputStream inputStream = Files.newInputStream(dependencyFile.toPath(), new OpenOption[0]);){
            this.govendorJson = GovendorJson.parse(inputStream);
            List<GoPackage> goPackages = this.govendorJson.getImports();
            this.checkForAndFillInMissingRevisions(goPackages, projectRoot.toPath().resolve(VENDOR_FOLDER));
            List<GoPackage> list = goPackages;
            return list;
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, e.getMessage()).initCause(e);
        }
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(VENDOR_JSON);
    }

    @Override
    protected String getIdentityFilename() {
        return VENDOR_JSON;
    }

    @Override
    @Nullable
    protected String getPackageNameUnderScan() {
        return this.govendorJson.getPackageName();
    }

    @Override
    @Nullable
    protected String getBinName() {
        return GOVENDOR;
    }

    @Override
    @Nullable
    protected List<String> getInstallArgs() {
        return Lists.newArrayList((Object[])new String[]{"sync"});
    }

    private void checkForAndFillInMissingRevisions(List<GoPackage> goPackages, Path vendorFolderPath) {
        ArrayList<GoPackage> toRemove = new ArrayList<GoPackage>();
        for (GoPackage goPackage : goPackages) {
            if (StringUtils.isNotBlank((String)goPackage.getRevision())) continue;
            Path packageSourceCodeDirectory = vendorFolderPath.resolve(goPackage.getImportPath());
            if (!Files.exists(packageSourceCodeDirectory, new LinkOption[0])) {
                LOGGER.debug("{} has empty revision in {}. import folder cannot be found in vendor folder too.", (Object)goPackage.getImportPath(), (Object)VENDOR_JSON);
                toRemove.add(goPackage);
                continue;
            }
            if (!Utils.directoryIsGitRepoOrGitSubRepo(packageSourceCodeDirectory)) {
                LOGGER.debug("{} has empty revision in {}. import folder {} does not have .git", new Object[]{goPackage.getImportPath(), VENDOR_JSON, packageSourceCodeDirectory});
                toRemove.add(goPackage);
                continue;
            }
            try {
                String revision = Utils.getCheckedOutRevision(packageSourceCodeDirectory);
                goPackage.setRevision(revision);
            }
            catch (CollectionException e) {
                LOGGER.debug("{} has empty revision in {}. Error occurred when attempting to get git revision from {}: {}", new Object[]{goPackage.getImportPath(), VENDOR_JSON, packageSourceCodeDirectory, e.getMessage()});
                toRemove.add(goPackage);
            }
        }
        goPackages.removeAll(toRemove);
    }
}

