/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.GoPackageManagerCollector;
import com.sourceclear.engine.component.golang.GoDependencyGraph;
import com.sourceclear.engine.component.golang.GoPackage;
import com.sourceclear.engine.component.golang.GopkgLockFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.graph.implementations.DefaultGraph;
import org.graphstream.stream.Sink;
import org.graphstream.stream.file.FileSourceDOT;

public class GolangDepNativeCollector
extends GoPackageManagerCollector {
    public static final String GOPKG_TOML = "Gopkg.toml";
    public static final String GOPKG_LOCK = "Gopkg.lock";
    public static final String DEP = "dep";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GopkgLockFile readLockFile(Path lockfile) throws CollectionException {
        try (InputStream inputStream = Files.newInputStream(lockfile, new OpenOption[0]);){
            GopkgLockFile gopkgLockFile = GopkgLockFile.parse(inputStream);
            return gopkgLockFile;
        }
        catch (IOException ex) {
            throw new CollectionException(CollectionErrorType.IO, String.format("An IOException occurred while parsing %s.", lockfile)).initCause(ex);
        }
    }

    static GoDependencyGraph dotFileToGoDependencyGraph(File dotFile) throws CollectionException {
        DefaultGraph graph = new DefaultGraph("g");
        FileSourceDOT fileSource = new FileSourceDOT();
        fileSource.addSink((Sink)graph);
        try {
            InputStream inputStream = Files.newInputStream(dotFile.toPath(), new OpenOption[0]);
            Object object = null;
            try {
                fileSource.readAll(inputStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CollectionException(CollectionErrorType.IO, "An IOException occurred while parsing the dependency tree from dep", e.getMessage());
        }
        finally {
            fileSource.removeSink((Sink)graph);
        }
        HashMap<String, Node> projectNameToNode = new HashMap<String, Node>();
        for (Node node : graph.getEachNode()) {
            projectNameToNode.put(GolangDepNativeCollector.projectName(node), node);
        }
        Node rootNode = graph.getNode(0);
        return GolangDepNativeCollector.getGraph(rootNode, projectNameToNode, (Graph)graph, new HashSet<Node>());
    }

    @Nullable
    private static GoDependencyGraph getGraph(Node node, Map<String, Node> projectNameToNode, Graph graph, Set<Node> seen) {
        if (seen.contains(node)) {
            return null;
        }
        String projectName = GolangDepNativeCollector.projectName(node);
        GoDependencyGraph goDependencyGraph = new GoDependencyGraph();
        goDependencyGraph.setImportPath(projectName);
        HashSet<GoDependencyGraph> children = new HashSet<GoDependencyGraph>();
        seen.add(node);
        for (Edge edge : graph.getNode(projectNameToNode.get(projectName).getId()).getEachLeavingEdge()) {
            Node child = edge.getNode1();
            GoDependencyGraph direct = GolangDepNativeCollector.getGraph(child, projectNameToNode, graph, seen);
            if (direct == null) continue;
            children.add(direct);
        }
        seen.remove(node);
        goDependencyGraph.setChildren(children);
        return goDependencyGraph;
    }

    private static String projectName(Node node) {
        String label = (String)node.getAttribute("label");
        return label.split("\\\\n")[0];
    }

    public GolangDepNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        super(logStream, attributes);
    }

    @Override
    public boolean supports(File projectPath) {
        return Files.exists(projectPath.toPath().resolve(GOPKG_LOCK), new LinkOption[0]) || Files.exists(projectPath.toPath().resolve(GOPKG_TOML), new LinkOption[0]);
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(GOPKG_TOML, GOPKG_LOCK);
    }

    @Override
    public String getName() {
        return "Dep";
    }

    @Override
    protected GoDependencyGraph getGoDependencyGraph(File goDepy, File projectRoot, List<String> goPaths) throws CollectionException {
        File dotFile = this.getDotFile(projectRoot, goPaths);
        LOGGER.debug("dot file '{}' created.", (Object)dotFile);
        GoDependencyGraph goDependencyGraph = GolangDepNativeCollector.dotFileToGoDependencyGraph(dotFile);
        dotFile.delete();
        LOGGER.debug("goDependencyGraph:\n{}", (Object)goDependencyGraph);
        return goDependencyGraph;
    }

    @Override
    protected List<GoPackage> getResolvedImports(File projectRoot, GoDependencyGraph goDependencyGraph, List<String> goPaths) throws CollectionException {
        Path lockfile = Paths.get(projectRoot.getAbsolutePath(), GOPKG_LOCK);
        if (!Files.exists(lockfile, new LinkOption[0])) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, String.format("Unable to collect dependencies information because %s is not present.%nSet '%s' to true to install dependencies and generate it.%nThe dependencies will be installed in a temporary folder and will not affect your workspace.", GOPKG_LOCK, "FORCE_GO_INSTALL"));
        }
        return GolangDepNativeCollector.readLockFile(lockfile).getGoPackages();
    }

    @Override
    @Nullable
    protected String getPackageNameUnderScan() {
        return null;
    }

    @Override
    protected String getIdentityFilename() {
        return GOPKG_LOCK;
    }

    @Override
    @Nullable
    public String getBinName() {
        return DEP;
    }

    @Override
    @Nullable
    protected List<String> getInstallArgs() {
        return Collections.singletonList("ensure");
    }

    private File getDotFile(File projectRoot, List<String> goPaths) throws CollectionException {
        List<String> commands = Arrays.asList(DEP, "status", "-dot");
        try {
            File dotFile = File.createTempFile("srcclr-", "-output.dot");
            dotFile.deleteOnExit();
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            processBuilder.command(commands);
            processBuilder.directory(projectRoot);
            this.updateMapWithGoPathAndGoRoot(processBuilder.environment(), goPaths);
            processBuilder.redirectOutput(dotFile);
            Process process = processBuilder.start();
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            int rc = process.waitFor();
            if (rc != 0) {
                String error = Joiner.on((String)"\n").join((Iterable)IOUtils.readLines((InputStream)process.getErrorStream(), (Charset)Charset.defaultCharset()));
                LOGGER.debug("Process to create dot file ended with non-zero output. rc={}. error: {}", (Object)rc, (Object)error);
                throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, "An error occurred while trying to get the dependency tree.", error);
            }
            return dotFile;
        }
        catch (IOException | InterruptedException e) {
            throw new CollectionException(CollectionErrorType.IO, "An IOException occurred while trying to get the dependency tree.", e.getMessage());
        }
    }
}

