/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.client.Client;
import com.sourceclear.api.client.SourceClearClient;
import com.sourceclear.api.data.analytics.BuildCommandType;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.api.data.generation.BuildSystemClientType;
import com.sourceclear.engine.common.DirUtils;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.sourceclear.engine.component.golang.GoDependencyGraph;
import com.sourceclear.engine.component.golang.GoPackage;
import com.sourceclear.util.io.IO;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GoPackageManagerCollector
implements NativeCollector {
    private static final String GO_DEPY_URL = "https://download.srcclr.com/go-depy/%s/%s";
    private static final String GO_DEPY_BIN_PREFIX = "go-depy";
    private static final String GO_DEPY_ARCH_386 = "386";
    private static final String GO_DEPY_ARCH_64 = "amd64";
    private static final String GO_DEPY_ARCH_ARM = "arm";
    private static final String GO_DEPY_WIN_EXT = ".exe";
    private static final File SRCCLR_HOME = Paths.get(System.getProperty("user.home"), ".srcclr").toFile();
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final String DUMMY_HEAD = "HEAD";
    private static final String GOPATH = "GOPATH";
    private static final String GOROOT = "GOROOT";
    protected static final Logger LOGGER = LoggerFactory.getLogger(GoPackageManagerCollector.class);
    protected final LogStream logStream;
    protected final ImmutableMap<String, Object> attributes;
    protected String userGoPath = "";
    protected final List<Path> filesToDelete = new ArrayList<Path>();
    private boolean goInstall = false;
    private final Client client;
    private final CollectorData.Builder collectorDataBuilder = new CollectorData.Builder();

    public static Coords toCoords(@Nonnull GoPackage goPackage) {
        Coords.Builder coordsBuilder = new Coords.Builder().withCoordinateType(CoordinateType.GO).withCoordinate1(goPackage.getCoord1());
        if (goPackage.revisionIsCommitHash()) {
            coordsBuilder.withVersion(DUMMY_HEAD);
            coordsBuilder.withCommitHash(goPackage.getRevision());
        } else {
            coordsBuilder.withVersion(goPackage.getRevision());
        }
        return coordsBuilder.build();
    }

    GoPackageManagerCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        this.logStream = logStream;
        this.attributes = attributes;
        SourceClearClient.Builder builder = new SourceClearClient.Builder().withExpBackOffInitial(0);
        URI apiBase = (URI)attributes.get((Object)"API_BASE_URI");
        if (apiBase != null) {
            builder.withBaseURI(apiBase);
        }
        this.client = builder.build();
    }

    @Override
    public boolean supports(File projectPath) {
        return this.identityFileExists(projectPath);
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        this.userGoPath = Strings.nullToEmpty((String)System.getenv(GOPATH));
        String binName = this.getBinName();
        boolean goPathSet = true;
        boolean binExists = true;
        if (StringUtils.isBlank((CharSequence)this.userGoPath)) {
            goPathSet = false;
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, "Please ensure that $GOPATH has been set in order to scan Go projects.");
        }
        if (binName != null) {
            try {
                CollectorUtils.resolveExeOrThrow(binName);
            }
            catch (CollectionException e) {
                this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage());
                binExists = false;
            }
        }
        return goPathSet && binExists;
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        try {
            File projectUnderScan;
            LOGGER.debug("Running '{}' collector.", (Object)this.getName());
            List<String> userGoPaths = Arrays.asList(this.userGoPath.split(File.pathSeparator));
            String repoUrl = (String)this.attributes.get((Object)"REPO_URL");
            String projectImportPath = this.getProjectImportPath(userGoPaths, projectRoot, repoUrl);
            LOGGER.debug("projectImportPath: {}", (Object)projectImportPath);
            ArrayList<String> goPathsInUse = new ArrayList<String>();
            boolean bl = this.goInstall = StringUtils.isNotBlank((CharSequence)repoUrl) || Boolean.valueOf(String.valueOf(this.attributes.get((Object)"FORCE_GO_INSTALL"))) != false;
            if (this.goInstall) {
                Pair<Path, Path> tempGoPathAndDuplicatedProject = this.createGoPathAndProject(projectRoot, projectImportPath);
                Path tempGoPath = (Path)tempGoPathAndDuplicatedProject.getLeft();
                Path duplicatedProject = (Path)tempGoPathAndDuplicatedProject.getRight();
                LOGGER.debug("Adding tempGoPath '{}' to list of files to be deleted after scan.", (Object)tempGoPath);
                this.filesToDelete.add(tempGoPath);
                this.filesToDelete.add(duplicatedProject);
                projectUnderScan = duplicatedProject.toFile();
                goPathsInUse.add(tempGoPath.toString());
                this.installDependenciesInProject(goPathsInUse, projectUnderScan);
            } else {
                projectUnderScan = projectRoot;
                goPathsInUse.addAll(userGoPaths);
            }
            File goDepy = this.getGoDepyFile();
            GoDependencyGraph goDependencyGraph = this.getGoDependencyGraph(goDepy, projectUnderScan, goPathsInUse);
            LOGGER.debug("dep graph completed.");
            this.collapseSubpackages(goDependencyGraph);
            LOGGER.debug("collapsed subPackages.");
            List<GoPackage> resolvedImports = this.getResolvedImports(projectUnderScan, goDependencyGraph, goPathsInUse);
            LOGGER.debug("Got list of resolved imports.");
            this.filterUnresolvedImports(resolvedImports, goDependencyGraph);
            LOGGER.debug("Filtered unresolved imports.");
            String identityFilename = this.getIdentityFilename();
            LibraryGraph.Builder builder = new LibraryGraph.Builder();
            if (StringUtils.isNotBlank((CharSequence)identityFilename)) {
                builder.withFilename(identityFilename);
            }
            for (GoDependencyGraph childGraph : goDependencyGraph.getChildren()) {
                builder.withDirect(this.buildComponent(identityFilename, childGraph, resolvedImports));
            }
            LibraryGraphContainer libraryGraphContainer = new LibraryGraphContainer.Builder().withGraph(builder.build()).build();
            return libraryGraphContainer;
        }
        finally {
            for (Path fileToDelete : this.filesToDelete) {
                if (!Files.exists(fileToDelete, new LinkOption[0])) continue;
                FileUtils.deleteQuietly((File)fileToDelete.toFile());
            }
        }
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        this.collectorDataBuilder.setCollectorName(this.getName()).setBuildCommand(Joiner.on((String)" ").join(this.getInstallCommand()));
        if (this.goInstall) {
            this.collectorDataBuilder.setBuildCommandType(BuildCommandType.DEFAULT);
        } else {
            this.collectorDataBuilder.setBuildCommandType(BuildCommandType.NOT_NEEDED);
            this.collectorDataBuilder.setBuildCommandSuccessful(true);
        }
        return this.collectorDataBuilder.build();
    }

    protected abstract List<GoPackage> getResolvedImports(File var1, GoDependencyGraph var2, List<String> var3) throws CollectionException;

    @Nullable
    protected abstract String getPackageNameUnderScan();

    protected abstract String getIdentityFilename();

    @Nullable
    protected abstract String getBinName();

    @Nullable
    protected abstract List<String> getInstallArgs();

    GoDependencyGraph getGoDependencyGraph(File goDepy, File projectRoot, List<String> goPaths) throws CollectionException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        List<String> commands = Arrays.asList(goDepy.getAbsolutePath(), projectRoot.getAbsolutePath());
        processBuilder.command(commands);
        processBuilder.redirectErrorStream(true);
        Map<String, String> processEnvVars = processBuilder.environment();
        this.updateMapWithGoPathAndGoRoot(processEnvVars, goPaths);
        String ignoreGoDirs = (String)this.attributes.get((Object)"IGNORE_GO_DIRS");
        if (StringUtils.isNotBlank((CharSequence)ignoreGoDirs)) {
            LOGGER.debug("user requested to ignore directories '{}'", (Object)ignoreGoDirs);
            processEnvVars.put("GODEPY_IGNORE_DIRS", ignoreGoDirs);
        }
        LOGGER.debug("GOPATH value for graph collection: {}", (Object)processEnvVars.get(GOPATH));
        LOGGER.debug("GOROOT value for graph collection: {}", (Object)processEnvVars.get(GOROOT));
        try {
            String output;
            File tmpOutputFile = File.createTempFile("tmpOutputFile", ".json");
            tmpOutputFile.deleteOnExit();
            processBuilder.redirectOutput(ProcessBuilder.Redirect.appendTo(tmpOutputFile));
            LOGGER.debug("redirecting process output to {}", (Object)tmpOutputFile.getAbsolutePath());
            LOGGER.debug("Launching process {}", (Object)Joiner.on((String)" ").join(commands));
            Process process = processBuilder.start();
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            int rc = process.waitFor();
            try (InputStream inputStream = Files.newInputStream(tmpOutputFile.toPath(), new OpenOption[0]);){
                output = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
            }
            LOGGER.debug(output);
            if (rc != 0) {
                throw new CollectionException(CollectionErrorType.UNKNOWN, String.format("An error occurred while attempting to get the project's dependencies. Please ensure that all the project's dependencies have been installed locally.%nYou can also install the dependencies during scanning by either setting the environment variable '%s=true', or setting '%s: true' in %s.", "SRCCLR_FORCE_GO_INSTALL", "FORCE_GO_INSTALL".toLowerCase(), "srcclr.yml"), output);
            }
            return (GoDependencyGraph)JSON_MAPPER.readValue(output, GoDependencyGraph.class);
        }
        catch (IOException | InterruptedException e) {
            LOGGER.debug("IOException/InterruptedException: {}", (Object)e.getMessage());
            throw new CollectionException(CollectionErrorType.IO, "IOException/InterruptedException occurred while attempting to get the project's dependencies.", e.getMessage()).initCause(e);
        }
    }

    File getGoDepyFile() throws CollectionException {
        String goDepyVersion = this.getGoDepyVersion();
        String binaryFilename = GoPackageManagerCollector.getBinaryFilenameToDownload(goDepyVersion);
        LOGGER.debug("godepy binary filename: {}", (Object)binaryFilename);
        try {
            URL url = new URL(String.format(GO_DEPY_URL, goDepyVersion, binaryFilename));
            File depyDirFile = new File(SRCCLR_HOME, GO_DEPY_BIN_PREFIX);
            return IO.downloadFileIntoDir(url, binaryFilename, depyDirFile, EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE), false);
        }
        catch (IOException ex) {
            LOGGER.debug("IOException: {}", (Object)ex.getMessage());
            throw new CollectionException(CollectionErrorType.IO, "An IOException occurred when attempting to scan the Go project.\nRun with --debug to print the stacktrace.").initCause(ex);
        }
    }

    static String getBinaryFilenameToDownload(String goDepyVersion) throws CollectionException {
        String archType;
        String osType;
        if (SystemUtils.IS_OS_MAC_OSX) {
            osType = GO_DEPY_OS_TYPES.DARWIN.toString().toLowerCase();
        } else if (SystemUtils.IS_OS_FREE_BSD) {
            osType = GO_DEPY_OS_TYPES.FREEBSD.toString().toLowerCase();
        } else if (SystemUtils.IS_OS_LINUX) {
            osType = GO_DEPY_OS_TYPES.LINUX.toString().toLowerCase();
        } else if (SystemUtils.IS_OS_NET_BSD) {
            osType = GO_DEPY_OS_TYPES.NETBSD.toString().toLowerCase();
        } else if (SystemUtils.IS_OS_OPEN_BSD) {
            osType = GO_DEPY_OS_TYPES.OPENBSD.toString().toLowerCase();
        } else if (SystemUtils.IS_OS_WINDOWS) {
            osType = GO_DEPY_OS_TYPES.WINDOWS.toString().toLowerCase();
        } else {
            throw new CollectionException(CollectionErrorType.SYSTEM, "Golang scanning is not supported on your OS: " + System.getProperty("os.name"));
        }
        String osArch = System.getProperty("os.arch");
        if (osArch.equalsIgnoreCase("i386") || osArch.equalsIgnoreCase(GO_DEPY_ARCH_386) || osArch.equalsIgnoreCase("x86")) {
            archType = GO_DEPY_ARCH_386;
        } else if (osArch.equalsIgnoreCase(GO_DEPY_ARCH_64) || osArch.equalsIgnoreCase("x64-64") || osArch.equalsIgnoreCase("x86_64")) {
            archType = GO_DEPY_ARCH_64;
        } else if (osArch.equalsIgnoreCase(GO_DEPY_ARCH_ARM)) {
            archType = GO_DEPY_ARCH_ARM;
        } else {
            throw new CollectionException(CollectionErrorType.SYSTEM, "Golang scanning is not supported on this arch type: " + osArch);
        }
        String extension = SystemUtils.IS_OS_WINDOWS ? GO_DEPY_WIN_EXT : "";
        return String.format("%s_%s_%s-%s%s", GO_DEPY_BIN_PREFIX, osType, archType, goDepyVersion, extension);
    }

    @Nullable
    static GoPackage findGoPackage(List<GoPackage> goPackages, String importPath) {
        String importPathWithoutSubModule = GoPackage.removeSubModulesIfPresent(importPath);
        for (GoPackage goPackage : goPackages) {
            if (!goPackage.getImportPath().equalsIgnoreCase(importPathWithoutSubModule)) continue;
            return goPackage;
        }
        return null;
    }

    String getGoDepyVersion() throws CollectionException {
        String goDepyVersion = System.getenv("SRCCLR_GO_DEPY_VERSION");
        if (StringUtils.isNotBlank((CharSequence)goDepyVersion)) {
            return goDepyVersion;
        }
        try {
            return this.client.getGenerationVersion(BuildSystemClientType.GO, 1L);
        }
        catch (IOException ex) {
            throw new CollectionException(CollectionErrorType.IO, "Couldn't execute Go evidence collection: " + ex.getMessage()).initCause(ex);
        }
    }

    protected String getProjectImportPath(List<String> userGoPaths, File projectRoot, String repoUrl) throws CollectionException {
        if (StringUtils.isNotBlank((CharSequence)repoUrl)) {
            try {
                return GoPackage.removeSubModulesAndProtocolIfPresent(repoUrl);
            }
            catch (URISyntaxException e) {
                throw new CollectionException(CollectionErrorType.SYSTEM, "Exception occurred while attempting to get project import path from repoUrl: " + repoUrl + ". Ex: " + e.getMessage());
            }
        }
        for (String userGoPathString : userGoPaths) {
            Path userGoPathSrcPath = Paths.get(userGoPathString, "src");
            if (!projectRoot.getAbsolutePath().startsWith(userGoPathSrcPath.toString())) continue;
            return GoPackage.removeSubModulesIfPresent(userGoPathSrcPath.relativize(projectRoot.toPath()).toString());
        }
        LOGGER.debug("repoUrl is empty and project is not under any GOPATH/src. Returning '{}' as projectImportPath", (Object)projectRoot.getName());
        this.logStream.log("com.srcclr.evidence.issue", Stage.EVIDENCE_COLLECTION, "* Warning *  This project does not reside in a configured $GOPATH.   Scanning may return incomplete results.");
        return projectRoot.getName();
    }

    Pair<Path, Path> createGoPathAndProject(File projectRoot, String projectImportPath) throws CollectionException {
        try {
            Path tempDirPath = Files.createTempDirectory("tmp-srcclr", new FileAttribute[0]).toRealPath(new LinkOption[0]);
            LOGGER.debug("creating temp path: {}", (Object)tempDirPath);
            Path copiedProjectInTempPath = Paths.get(tempDirPath.toString(), "src", projectImportPath);
            DirUtils.copyDirectory(projectRoot.toPath(), copiedProjectInTempPath);
            LOGGER.debug("copied directory to mock GOPATH folder.");
            return Pair.of((Object)tempDirPath, (Object)copiedProjectInTempPath);
        }
        catch (IOException e) {
            LOGGER.debug("IOException/InterruptedException when creating temp gopath dir: {}", (Object)e.getMessage());
            throw new CollectionException(CollectionErrorType.IO, "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.", e.getMessage()).initCause(e);
        }
    }

    void updateMapWithGoPathAndGoRoot(Map<String, String> map, List<String> goPaths) throws CollectionException {
        String goPath = this.joinMultiplePathsToSingleWithOsSeparator(goPaths);
        if (StringUtils.isNotBlank((CharSequence)goPath)) {
            map.put(GOPATH, goPath);
        }
        if (StringUtils.isBlank((CharSequence)map.get(GOROOT))) {
            String goEnvGoRoot = this.valueFromGoEnv(GOROOT);
            if (StringUtils.isNotBlank((CharSequence)goEnvGoRoot)) {
                map.put(GOROOT, goEnvGoRoot);
            } else {
                LOGGER.warn("No GOROOT value found. Continuing with scan.");
            }
        }
    }

    private boolean identityFileExists(File projectPath) {
        return Files.exists(projectPath.toPath().resolve(this.getIdentityFilename()), new LinkOption[0]);
    }

    private LibraryGraph buildComponent(String identityFilename, GoDependencyGraph goDependencyGraph, List<GoPackage> resolvedImports) throws CollectionException {
        GoPackage goPackage;
        LibraryGraph.Builder builder = new LibraryGraph.Builder();
        if (StringUtils.isNotBlank((CharSequence)identityFilename)) {
            builder.withFilename(identityFilename);
        }
        if ((goPackage = GoPackageManagerCollector.findGoPackage(resolvedImports, goDependencyGraph.getImportPath())) == null) {
            throw new CollectionException(CollectionErrorType.PACKAGE_MANAGER, String.format("'%s' is in dependency graph but not in '%s'. Check that '%s' is up-to-date.", goDependencyGraph.getImportPath(), identityFilename, identityFilename));
        }
        builder.withCoords(GoPackageManagerCollector.toCoords(goPackage));
        if (goPackage.getLineNumber() > 0) {
            builder.withLineNumber(Integer.valueOf(goPackage.getLineNumber()));
        }
        for (GoDependencyGraph childGraph : goDependencyGraph.getChildren()) {
            LibraryGraph childDirectLibGraph = this.buildComponent(identityFilename, childGraph, resolvedImports);
            if (childDirectLibGraph.getCoords().getCoordinate1().equals(goPackage.getCoord1())) {
                builder.withDirects(childDirectLibGraph.getDirects());
                continue;
            }
            builder.withDirect(childDirectLibGraph);
        }
        return builder.build();
    }

    private void collapseSubpackages(GoDependencyGraph goDependencyGraph) {
        Set<GoDependencyGraph> children = goDependencyGraph.getChildren();
        String currentGraphImportPath = goDependencyGraph.getImportPath();
        for (GoDependencyGraph childGraph : children) {
            this.collapseSubpackages(childGraph);
        }
        HashSet<GoDependencyGraph> collapsedList = new HashSet<GoDependencyGraph>();
        for (GoDependencyGraph childGraph : children) {
            String childGraphImportPath = childGraph.getImportPath();
            if (GoPackage.isSameMainPackage(currentGraphImportPath, childGraphImportPath)) {
                LOGGER.debug("Absorbing '{}' dependencies into '{}' because former is a subpackage of latter.", (Object)childGraphImportPath, (Object)currentGraphImportPath);
                collapsedList.addAll(childGraph.getChildren());
                continue;
            }
            if (Paths.get(currentGraphImportPath, new String[0]).isAbsolute() && currentGraphImportPath.endsWith(GoPackage.removeSubModulesIfPresent(childGraphImportPath))) {
                LOGGER.debug("'{}' belongs to the project under scan '{}'", (Object)childGraphImportPath, (Object)currentGraphImportPath);
                collapsedList.addAll(childGraph.getChildren());
                continue;
            }
            GoDependencyGraph sameImportPathGraph = null;
            for (GoDependencyGraph collapsedListGraph : collapsedList) {
                if (!GoPackage.isSameMainPackage(collapsedListGraph.getImportPath(), childGraphImportPath)) continue;
                sameImportPathGraph = collapsedListGraph;
                break;
            }
            if (sameImportPathGraph != null) {
                sameImportPathGraph.getChildren().addAll(childGraph.getChildren());
                continue;
            }
            collapsedList.add(childGraph);
        }
        if (Paths.get(currentGraphImportPath, new String[0]).isAbsolute()) {
            goDependencyGraph.setImportPath(currentGraphImportPath);
        } else {
            goDependencyGraph.setImportPath(GoPackage.removeSubModulesIfPresent(currentGraphImportPath));
        }
        goDependencyGraph.setChildren(collapsedList);
    }

    private void filterUnresolvedImports(List<GoPackage> resolvedImports, GoDependencyGraph goDependencyGraph) {
        Set<GoDependencyGraph> children = goDependencyGraph.getChildren();
        String currentGraphImportPath = goDependencyGraph.getImportPath();
        for (GoDependencyGraph childGraph : children) {
            this.filterUnresolvedImports(resolvedImports, childGraph);
        }
        HashSet<GoDependencyGraph> collapsedList = new HashSet<GoDependencyGraph>();
        for (GoDependencyGraph childGraph : children) {
            String childGraphImportPath = childGraph.getImportPath();
            if (GoPackageManagerCollector.findGoPackage(resolvedImports, childGraphImportPath) == null) {
                LOGGER.debug("Absorbing '{}' dependencies into '{}' because the former can't be found in resolvedImports", (Object)childGraphImportPath, (Object)currentGraphImportPath);
                collapsedList.addAll(childGraph.getChildren());
                continue;
            }
            collapsedList.add(childGraph);
        }
        goDependencyGraph.setChildren(collapsedList);
    }

    @Nonnull
    private List<String> getInstallCommand() {
        ArrayList<String> cmd = new ArrayList<String>();
        String binName = this.getBinName();
        if (binName != null) {
            List<String> installArgs = this.getInstallArgs();
            if (installArgs == null) {
                throw new RuntimeException(this.getClass().getName() + " has bin `" + binName + "` but installArgs is null.");
            }
            cmd.add(binName);
            cmd.addAll(installArgs);
        }
        return cmd;
    }

    private void installDependenciesInProject(List<String> goPaths, File project) throws CollectionException {
        List<String> installCommand = this.getInstallCommand();
        if (!installCommand.isEmpty()) {
            File exe = CollectorUtils.resolveExeOrThrow(installCommand.get(0));
            installCommand.set(0, exe.getAbsolutePath());
            this.installDependenciesProcess(goPaths, project, installCommand);
        }
    }

    private void installDependenciesProcess(List<String> goPaths, File projectPath, List<String> command) throws CollectionException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.directory(projectPath);
        processBuilder.redirectErrorStream(true);
        processBuilder.command(command);
        Map<String, String> processEnvVars = processBuilder.environment();
        String goPath = this.joinMultiplePathsToSingleWithOsSeparator(goPaths);
        if (StringUtils.isNotBlank((CharSequence)goPath)) {
            processEnvVars.put(GOPATH, goPath);
        }
        try {
            String outAndErr;
            File tmpOutputFile = File.createTempFile("tmpOutputFile", ".json");
            tmpOutputFile.deleteOnExit();
            processBuilder.redirectOutput(tmpOutputFile);
            LOGGER.debug("launching install command: '{}' in directory {}", (Object)Joiner.on((String)" ").join(command), (Object)projectPath);
            Process process = processBuilder.start();
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            int rc = process.waitFor();
            try (InputStream is = Files.newInputStream(tmpOutputFile.toPath(), new OpenOption[0]);){
                outAndErr = IOUtils.toString((InputStream)is, (Charset)Charset.defaultCharset());
            }
            if (rc != 0) {
                this.collectorDataBuilder.setBuildCommandSuccessful(false);
                LOGGER.debug("install command error: {}", (Object)outAndErr);
                throw new CollectionException(CollectionErrorType.SYSTEM, "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.", outAndErr);
            }
            this.collectorDataBuilder.setBuildCommandSuccessful(true);
            LOGGER.debug("install command output: {}", (Object)outAndErr);
        }
        catch (IOException | InterruptedException e) {
            this.collectorDataBuilder.setBuildCommandSuccessful(false);
            LOGGER.debug("install command IOException/InterruptedException: {}", (Object)e.getMessage());
            throw new CollectionException(CollectionErrorType.IO, "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.", e.getMessage()).initCause(e);
        }
    }

    private String valueFromGoEnv(String varName) throws CollectionException {
        List<String> command = Arrays.asList("go", "env", varName);
        List<String> output = CollectorUtils.launchProcess(command, null, null, LOGGER);
        return output.isEmpty() ? "" : output.get(0).trim();
    }

    private String joinMultiplePathsToSingleWithOsSeparator(List<String> paths) {
        return Joiner.on((String)File.pathSeparator).join(paths);
    }

    private static enum GO_DEPY_OS_TYPES {
        DARWIN,
        FREEBSD,
        LINUX,
        NETBSD,
        OPENBSD,
        WINDOWS;

    }
}

