/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.component.collectors;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.analytics.CollectorData;
import com.sourceclear.api.data.evidence.CollectionErrorType;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.common.logging.Stage;
import com.sourceclear.engine.component.CollectionException;
import com.sourceclear.engine.component.cocoapods.Dependency;
import com.sourceclear.engine.component.cocoapods.Pod;
import com.sourceclear.engine.component.cocoapods.PodLockFile;
import com.sourceclear.engine.component.cocoapods.PodLockFileParser;
import com.sourceclear.engine.component.collectors.CollectorUtils;
import com.sourceclear.engine.component.collectors.NativeCollector;
import com.srcclr.sdk.CoordinateType;
import com.srcclr.sdk.Coords;
import com.srcclr.sdk.LibraryGraph;
import com.srcclr.sdk.LibraryGraphContainer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CocoaPodsNativeCollector
implements NativeCollector {
    public static final String PODFILE_LOCK_NAME = "Podfile.lock";
    private static final String PODFILE_NAME = "Podfile";
    private static final Path PODFILE_LOCK = Paths.get("Podfile.lock", new String[0]);
    private static final Path PODFILE = Paths.get("Podfile", new String[0]);
    private static final String POD = "pod";
    private static final Logger LOGGER = LoggerFactory.getLogger(CocoaPodsNativeCollector.class);
    private final LogStream logStream;
    private final ImmutableMap<String, Object> attributes;

    public CocoaPodsNativeCollector(LogStream logStream, ImmutableMap<String, Object> attributes) {
        this.logStream = logStream;
        this.attributes = attributes;
    }

    @Override
    public String getName() {
        return "Cocoapods";
    }

    @Override
    public boolean supports(File projectPath) {
        return this.fileExists(projectPath.toPath(), PODFILE_LOCK) || this.fileExists(projectPath.toPath(), PODFILE);
    }

    @Override
    public Set<Pattern> patternsOfInterest() {
        return CollectorUtils.regexifyFileNames(PODFILE_LOCK_NAME, PODFILE_NAME);
    }

    @Override
    public boolean systemIsReady(File projectDir) {
        if (this.fileExists(projectDir.toPath(), PODFILE_LOCK)) {
            return true;
        }
        try {
            CollectorUtils.resolveExeOrThrow(POD);
        }
        catch (CollectionException e) {
            this.logStream.log("com.srcclr.engineconfig.issue", Stage.ENGINE_CONFIGURATION, e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean isMethodsSupported(File projectRoot) {
        return false;
    }

    @Override
    @Nonnull
    public LibraryGraphContainer collect(File projectRoot) throws CollectionException {
        PodLockFile podLockFile;
        if (!this.fileExists(projectRoot.toPath(), PODFILE_LOCK)) {
            LOGGER.debug("{} not found. Running pod install to generate it.", (Object)PODFILE_LOCK);
            this.runPodInstall(projectRoot);
        }
        Path file = projectRoot.toPath().resolve(PODFILE_LOCK);
        try (InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);){
            podLockFile = PodLockFileParser.parse(inputStream);
        }
        catch (Exception e) {
            throw new CollectionException(CollectionErrorType.PARSE, String.format("Unable to parse %s.", file.toString()));
        }
        LibraryGraph graph = CocoaPodsNativeCollector.podLockFileToGraph(podLockFile);
        return new LibraryGraphContainer.Builder().withGraph(graph).build();
    }

    public static LibraryGraph podLockFileToGraph(PodLockFile podLockFile) {
        List<Pod> pods = podLockFile.getPods();
        Map<Pod, Set<Pod>> podDeps = CocoaPodsNativeCollector.toPodDependencyMap(pods);
        podDeps = CocoaPodsNativeCollector.collapseLibrariesWithModules(podDeps);
        LibraryGraph.Builder builder = new LibraryGraph.Builder();
        builder.withFilename(PODFILE_LOCK_NAME);
        List<Dependency> dependencies = podLockFile.getDependencies();
        for (Dependency dependency : dependencies) {
            String name = dependency.getName();
            Optional<Pod> optionalPod = CocoaPodsNativeCollector.findPod(pods, name);
            if (!optionalPod.isPresent()) continue;
            Pod pod = (Pod)optionalPod.get();
            builder.withDirect(CocoaPodsNativeCollector.podToLibraryGraph(podDeps, pod));
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public CollectorData getCollectorData() {
        return new CollectorData.Builder().setCollectorName(this.getName()).build();
    }

    static Map<Pod, Set<Pod>> collapseLibrariesWithModules(Map<Pod, Set<Pod>> podDeps) {
        HashMap<Pod, Set<Pod>> podDepsCopy = new HashMap<Pod, Set<Pod>>(podDeps);
        HashMap<Pod, Set<Pod>> temp = new HashMap<Pod, Set<Pod>>();
        for (Map.Entry<Pod, Set<Pod>> entry : podDepsCopy.entrySet()) {
            Pod pod = entry.getKey();
            Set<Pod> deps = entry.getValue();
            if (CocoaPodsNativeCollector.isModule(pod)) {
                String libraryName = CocoaPodsNativeCollector.stripModuleName(pod.getName());
                Optional<Map.Entry<Pod, Set<Pod>>> libraryEntry = CocoaPodsNativeCollector.findPodEntry(temp, libraryName);
                if (libraryEntry.isPresent() || (libraryEntry = CocoaPodsNativeCollector.findPodEntry(podDepsCopy, libraryName)).isPresent()) {
                    ((Set)((Map.Entry)libraryEntry.get()).getValue()).addAll(deps);
                    continue;
                }
                temp.put(pod, deps);
                continue;
            }
            temp.put(pod, deps);
        }
        return CocoaPodsNativeCollector.removeModules(temp);
    }

    static Map<Pod, Set<Pod>> removeModules(Map<Pod, Set<Pod>> podDeps) {
        HashMap<Pod, Set<Pod>> result = new HashMap<Pod, Set<Pod>>();
        for (Map.Entry<Pod, Set<Pod>> entry : podDeps.entrySet()) {
            Pod pod = entry.getKey();
            Set<Pod> deps = entry.getValue();
            HashSet<Pod> newDeps = new HashSet<Pod>();
            for (Pod dep : deps) {
                if (CocoaPodsNativeCollector.stripModuleName(dep.getName()).equals(pod.getName())) continue;
                newDeps.add(dep);
            }
            result.put(pod, newDeps);
        }
        return result;
    }

    private static boolean isModule(Pod pod) {
        return pod.getName().contains("/");
    }

    private static Map<Pod, Set<Pod>> toPodDependencyMap(List<Pod> pods) {
        HashMap<Pod, Set<Pod>> map = new HashMap<Pod, Set<Pod>>();
        for (Pod pod : pods) {
            HashSet<Object> deps = new HashSet<Object>();
            List<Dependency> dependencies = pod.getDependencies();
            for (Dependency dependency : dependencies) {
                String name = dependency.getName();
                Optional<Pod> p = CocoaPodsNativeCollector.findPod(pods, name);
                if (!p.isPresent()) continue;
                deps.add(p.get());
            }
            map.put(pod, deps);
        }
        return map;
    }

    static LibraryGraph podToLibraryGraph(Map<Pod, Set<Pod>> podDeps, Pod pod) {
        LibraryGraph.Builder builder = new LibraryGraph.Builder();
        Coords coords = new Coords.Builder().withCoordinate1(pod.getName()).withVersion(pod.getVersion()).withCoordinateType(CoordinateType.COCOAPODS).build();
        Set<Pod> dependencies = podDeps.get(pod);
        if (dependencies != null) {
            for (Pod dependency : dependencies) {
                builder.withDirect(CocoaPodsNativeCollector.podToLibraryGraph(podDeps, dependency));
            }
        }
        return builder.withCoords(coords).withLineNumber(Integer.valueOf(pod.getLineNumber())).withFilename(PODFILE_LOCK_NAME).build();
    }

    static String stripModuleName(String libraryName) {
        int slashIndex = libraryName.indexOf("/");
        if (slashIndex == -1) {
            return libraryName;
        }
        return libraryName.split("/")[0];
    }

    static Optional<Map.Entry<Pod, Set<Pod>>> findPodEntry(Map<Pod, Set<Pod>> podDeps, String podName) {
        for (Map.Entry<Pod, Set<Pod>> podSetEntry : podDeps.entrySet()) {
            if (!podSetEntry.getKey().getName().equals(podName)) continue;
            return Optional.of(podSetEntry);
        }
        return Optional.absent();
    }

    static Optional<Pod> findPod(List<Pod> pods, String podName) {
        for (Pod pod : pods) {
            if (!pod.getName().equals(podName)) continue;
            return Optional.of((Object)pod);
        }
        return Optional.absent();
    }

    private boolean fileExists(Path projectPath, Path fileToChecl) {
        return Files.exists(projectPath.resolve(fileToChecl), new LinkOption[0]);
    }

    private void runPodInstall(File projectRoot) throws CollectionException {
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(projectRoot);
        CollectorUtils.populateEnvVars(this.attributes, processBuilder);
        List<String> commands = Arrays.asList(POD, "install");
        processBuilder.command(commands);
        try {
            Future<String> stringFuture;
            Process process = processBuilder.start();
            IOUtils.closeQuietly((OutputStream)process.getOutputStream());
            int rc = process.waitFor();
            try (InputStream is = process.getInputStream();){
                stringFuture = CollectorUtils.readAsync(is, this.logStream, LOGGER, "com.srcclr.evidence.start", Stage.EVIDENCE_COLLECTION);
            }
            if (rc != 0) {
                String output = stringFuture.get();
                LOGGER.debug("'pod install' exited with non-zero error code: {}. Output/error: {}", (Object)rc, (Object)output);
                throw new CollectionException(CollectionErrorType.UNKNOWN, "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.", output);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new CollectionException(CollectionErrorType.IO, "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.", e.getMessage()).initCause(e);
        }
        catch (ExecutionException e) {
            throw new CollectionException(CollectionErrorType.UNKNOWN, "This project does not seem to build.\nBecause of this, SourceClear cannot scan it. Please ensure that the project compiles prior to scanning.", "'pod install' exited with non-zero error code. However an ExecutionException occurred when getting the process error: " + e.getMessage()).initCause(e);
        }
    }
}

