/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.bytecode;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.sourceclear.bytecode.ClassFingerprint;
import com.sourceclear.bytecode.CompFingerprint;
import com.sourceclear.bytecode.HashedClassFingerprint;
import com.sourceclear.bytecode.Util;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashedCompFingerprint {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HashedCompFingerprint.class.getName());
    public TreeMap<Integer, HashedClassFingerprint> hashedClassMap = new TreeMap();

    public HashedCompFingerprint() {
    }

    public HashedCompFingerprint(CompFingerprint jfp) {
        for (String s : jfp.getClassMap().keySet()) {
            ClassFingerprint cfp = jfp.getClassMap().get(s);
            HashedClassFingerprint hcfp = new HashedClassFingerprint(cfp);
            this.hashedClassMap.put(s.hashCode(), hcfp);
        }
    }

    public String hash() {
        ArrayList hashes = Lists.newArrayList();
        for (Integer i : this.hashedClassMap.keySet()) {
            hashes.add(Ints.toByteArray((int)i));
        }
        for (HashedClassFingerprint p : this.hashedClassMap.values()) {
            hashes.add(p.getHash());
        }
        if (hashes.isEmpty()) {
            return null;
        }
        return Hex.encodeHexString((byte[])Util.hashBytes(hashes));
    }

    public CompFingerprint convertHashedCompFingerprint() {
        ImmutableMap.Builder classMap = new ImmutableMap.Builder();
        for (Integer i : this.hashedClassMap.keySet()) {
            HashedClassFingerprint hcfp = this.hashedClassMap.get(i);
            ClassFingerprint cf = new ClassFingerprint(hcfp);
            classMap.put((Object)i.toString(), (Object)cf);
        }
        return new CompFingerprint((Map<String, ClassFingerprint>)classMap.build());
    }

    public ByteArrayOutputStream serializeClassMap() throws IOException {
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream(boas);){
            ZipEntry ze = new ZipEntry("_file_");
            zos.putNextEntry(ze);
            ObjectOutputStream oos = new ObjectOutputStream(zos);
            oos.writeObject(this.hashedClassMap);
            zos.closeEntry();
        }
        return boas;
    }

    public void deserializeClassMap(InputStream is) {
        try {
            ZipInputStream zin = new ZipInputStream(is);
            zin.getNextEntry();
            try (ObjectInputStream ois = new ObjectInputStream(zin);){
                this.hashedClassMap = (TreeMap)ois.readObject();
                zin.close();
            }
            catch (ClassNotFoundException ex) {
                LOGGER.error("Class not found" + ex.getMessage());
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.error("Hashed fingerprint file not found" + ex.getMessage());
        }
        catch (IOException ex) {
            LOGGER.error("Cannot deserialize class map from hashedjarfingerprint" + ex.getMessage());
        }
        LOGGER.debug("Deserialized classmap");
    }
}

