/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.methods;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.sourceclear.api.data.methods.ValidMethod;
import java.util.Objects;
import javax.annotation.Nonnull;

@ValidMethod
@JsonIgnoreProperties(ignoreUnknown=true)
public class MethodModel
implements Comparable<MethodModel> {
    private final String moduleName;
    private final String className;
    private final String methodName;
    private final String descriptor;

    public MethodModel(@JsonProperty(value="moduleName") String moduleName, @JsonProperty(value="className") String className, @JsonProperty(value="methodName") String methodName, @JsonProperty(value="descriptor") String descriptor) {
        this.moduleName = Strings.emptyToNull((String)moduleName);
        this.className = Strings.emptyToNull((String)className);
        this.methodName = Strings.emptyToNull((String)methodName);
        this.descriptor = Strings.isNullOrEmpty((String)descriptor) ? null : descriptor.replaceAll("\\s+", "");
    }

    @Override
    public int compareTo(@Nonnull MethodModel o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.moduleName), (Comparable)((Object)o.moduleName)).compare((Comparable)((Object)this.className), (Comparable)((Object)o.className)).compare((Comparable)((Object)this.methodName), (Comparable)((Object)o.methodName)).compare((Comparable)((Object)this.descriptor), (Comparable)((Object)o.descriptor)).result();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("moduleName", (Object)this.moduleName).add("className", (Object)this.className).add("methodName", (Object)this.methodName).add("descriptor", (Object)this.descriptor).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodModel that = (MethodModel)o;
        return Objects.equals(this.moduleName, that.moduleName) && Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.descriptor, that.descriptor);
    }

    public int hashCode() {
        return Objects.hash(this.moduleName, this.className, this.methodName, this.descriptor);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getDescriptor() {
        return this.descriptor;
    }
}

