/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sourceclear.api.data.analytics.AgentRuntimeData;
import com.sourceclear.api.data.methods.InstanceVulnMethod;
import com.sourceclear.api.data.methods.InstanceVulnMethodUpload;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;
import javax.annotation.Nullable;

abstract class InstanceVulnMethodUpload_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private List<InstanceVulnMethod> vulnMethods = ImmutableList.of();
    @Nullable
    private AgentRuntimeData agentRuntimeData = null;

    InstanceVulnMethodUpload_Builder() {
    }

    public static InstanceVulnMethodUpload.Builder from(InstanceVulnMethodUpload value) {
        return new InstanceVulnMethodUpload.Builder().mergeFrom(value);
    }

    public InstanceVulnMethodUpload.Builder addVulnMethods(InstanceVulnMethod element) {
        if (this.vulnMethods instanceof ImmutableList) {
            this.vulnMethods = new ArrayList<InstanceVulnMethod>(this.vulnMethods);
        }
        this.vulnMethods.add((InstanceVulnMethod)Preconditions.checkNotNull((Object)element));
        return (InstanceVulnMethodUpload.Builder)this;
    }

    public InstanceVulnMethodUpload.Builder addVulnMethods(InstanceVulnMethod ... elements) {
        return this.addAllVulnMethods(Arrays.asList(elements));
    }

    public InstanceVulnMethodUpload.Builder addAllVulnMethods(Spliterator<? extends InstanceVulnMethod> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.vulnMethods instanceof ImmutableList) {
                this.vulnMethods = new ArrayList<InstanceVulnMethod>(this.vulnMethods);
            }
            ((ArrayList)this.vulnMethods).ensureCapacity(this.vulnMethods.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addVulnMethods);
        return (InstanceVulnMethodUpload.Builder)this;
    }

    public InstanceVulnMethodUpload.Builder addAllVulnMethods(BaseStream<? extends InstanceVulnMethod, ?> elements) {
        return this.addAllVulnMethods(elements.spliterator());
    }

    @JsonProperty(value="vulnMethods")
    public InstanceVulnMethodUpload.Builder addAllVulnMethods(Iterable<? extends InstanceVulnMethod> elements) {
        return this.addAllVulnMethods(elements.spliterator());
    }

    public InstanceVulnMethodUpload.Builder mutateVulnMethods(Consumer<? super List<InstanceVulnMethod>> mutator) {
        if (this.vulnMethods instanceof ImmutableList) {
            this.vulnMethods = new ArrayList<InstanceVulnMethod>(this.vulnMethods);
        }
        mutator.accept(this.vulnMethods);
        return (InstanceVulnMethodUpload.Builder)this;
    }

    public InstanceVulnMethodUpload.Builder clearVulnMethods() {
        if (this.vulnMethods instanceof ImmutableList) {
            this.vulnMethods = ImmutableList.of();
        } else {
            this.vulnMethods.clear();
        }
        return (InstanceVulnMethodUpload.Builder)this;
    }

    public List<InstanceVulnMethod> getVulnMethods() {
        if (this.vulnMethods instanceof ImmutableList) {
            this.vulnMethods = new ArrayList<InstanceVulnMethod>(this.vulnMethods);
        }
        return Collections.unmodifiableList(this.vulnMethods);
    }

    @JsonProperty(value="agentRuntimeData")
    public InstanceVulnMethodUpload.Builder setAgentRuntimeData(@Nullable AgentRuntimeData agentRuntimeData) {
        this.agentRuntimeData = agentRuntimeData;
        return (InstanceVulnMethodUpload.Builder)this;
    }

    public InstanceVulnMethodUpload.Builder mapAgentRuntimeData(UnaryOperator<AgentRuntimeData> mapper) {
        Preconditions.checkNotNull(mapper);
        AgentRuntimeData agentRuntimeData = this.getAgentRuntimeData();
        if (agentRuntimeData != null) {
            this.setAgentRuntimeData((AgentRuntimeData)mapper.apply(agentRuntimeData));
        }
        return (InstanceVulnMethodUpload.Builder)this;
    }

    @Nullable
    public AgentRuntimeData getAgentRuntimeData() {
        return this.agentRuntimeData;
    }

    public InstanceVulnMethodUpload.Builder mergeFrom(InstanceVulnMethodUpload value) {
        InstanceVulnMethodUpload.Builder _defaults = new InstanceVulnMethodUpload.Builder();
        if (value instanceof Value && this.vulnMethods == ImmutableList.of()) {
            this.vulnMethods = ImmutableList.copyOf(value.getVulnMethods());
        } else {
            this.addAllVulnMethods(value.getVulnMethods());
        }
        if (!Objects.equals(value.getAgentRuntimeData(), ((InstanceVulnMethodUpload_Builder)_defaults).getAgentRuntimeData())) {
            this.setAgentRuntimeData(value.getAgentRuntimeData());
        }
        return (InstanceVulnMethodUpload.Builder)this;
    }

    public InstanceVulnMethodUpload.Builder mergeFrom(InstanceVulnMethodUpload.Builder template) {
        InstanceVulnMethodUpload.Builder base = template;
        InstanceVulnMethodUpload.Builder _defaults = new InstanceVulnMethodUpload.Builder();
        this.addAllVulnMethods(base.vulnMethods);
        if (!Objects.equals(template.getAgentRuntimeData(), ((InstanceVulnMethodUpload_Builder)_defaults).getAgentRuntimeData())) {
            this.setAgentRuntimeData(template.getAgentRuntimeData());
        }
        return (InstanceVulnMethodUpload.Builder)this;
    }

    public InstanceVulnMethodUpload.Builder clear() {
        InstanceVulnMethodUpload.Builder _defaults = new InstanceVulnMethodUpload.Builder();
        this.clearVulnMethods();
        this.agentRuntimeData = _defaults.agentRuntimeData;
        return (InstanceVulnMethodUpload.Builder)this;
    }

    public InstanceVulnMethodUpload build() {
        return new Value(this);
    }

    @VisibleForTesting
    public InstanceVulnMethodUpload buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements InstanceVulnMethodUpload {
        private final List<InstanceVulnMethod> vulnMethods;
        @Nullable
        private final AgentRuntimeData agentRuntimeData;

        Partial(InstanceVulnMethodUpload_Builder builder) {
            this.vulnMethods = ImmutableList.copyOf((Collection)builder.vulnMethods);
            this.agentRuntimeData = builder.agentRuntimeData;
        }

        @Override
        @JsonProperty(value="vulnMethods")
        public List<InstanceVulnMethod> getVulnMethods() {
            return this.vulnMethods;
        }

        @Override
        @JsonProperty(value="agentRuntimeData")
        @Nullable
        public AgentRuntimeData getAgentRuntimeData() {
            return this.agentRuntimeData;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.vulnMethods, other.vulnMethods) && Objects.equals(this.agentRuntimeData, other.agentRuntimeData);
        }

        public int hashCode() {
            return Objects.hash(this.vulnMethods, this.agentRuntimeData);
        }

        public String toString() {
            return "partial InstanceVulnMethodUpload{" + COMMA_JOINER.join((Object)("vulnMethods=" + this.vulnMethods), this.agentRuntimeData != null ? "agentRuntimeData=" + this.agentRuntimeData : null, new Object[0]) + "}";
        }
    }

    private static final class Value
    implements InstanceVulnMethodUpload {
        private final List<InstanceVulnMethod> vulnMethods;
        @Nullable
        private final AgentRuntimeData agentRuntimeData;

        private Value(InstanceVulnMethodUpload_Builder builder) {
            this.vulnMethods = ImmutableList.copyOf((Collection)builder.vulnMethods);
            this.agentRuntimeData = builder.agentRuntimeData;
        }

        @Override
        @JsonProperty(value="vulnMethods")
        public List<InstanceVulnMethod> getVulnMethods() {
            return this.vulnMethods;
        }

        @Override
        @JsonProperty(value="agentRuntimeData")
        @Nullable
        public AgentRuntimeData getAgentRuntimeData() {
            return this.agentRuntimeData;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.vulnMethods, other.vulnMethods) && Objects.equals(this.agentRuntimeData, other.agentRuntimeData);
        }

        public int hashCode() {
            return Objects.hash(this.vulnMethods, this.agentRuntimeData);
        }

        public String toString() {
            return "InstanceVulnMethodUpload{" + COMMA_JOINER.join((Object)("vulnMethods=" + this.vulnMethods), this.agentRuntimeData != null ? "agentRuntimeData=" + this.agentRuntimeData : null, new Object[0]) + "}";
        }
    }
}

