/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.match;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.sourceclear.api.data.match.SafeVersionsQuery;
import com.sourceclear.api.data.match.SafeVersionsResponse;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

abstract class SafeVersionsResponse_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private final SafeVersionsQuery.Builder safeVersionsQuery = new SafeVersionsQuery.Builder();
    private final LinkedHashMap<Long, List<SafeVersionsResponse.SafeVersion>> safeVersions = new LinkedHashMap();

    SafeVersionsResponse_Builder() {
    }

    public static SafeVersionsResponse.Builder from(SafeVersionsResponse value) {
        return new SafeVersionsResponse.Builder().mergeFrom(value);
    }

    @JsonProperty(value="safeVersionsQuery")
    public SafeVersionsResponse.Builder setSafeVersionsQuery(SafeVersionsQuery safeVersionsQuery) {
        Preconditions.checkNotNull((Object)safeVersionsQuery);
        this.safeVersionsQuery.clear();
        this.safeVersionsQuery.mergeFrom(safeVersionsQuery);
        return (SafeVersionsResponse.Builder)this;
    }

    public SafeVersionsResponse.Builder setSafeVersionsQuery(SafeVersionsQuery.Builder builder) {
        return this.setSafeVersionsQuery(builder.build());
    }

    public SafeVersionsResponse.Builder mutateSafeVersionsQuery(Consumer<SafeVersionsQuery.Builder> mutator) {
        mutator.accept(this.safeVersionsQuery);
        return (SafeVersionsResponse.Builder)this;
    }

    public SafeVersionsQuery.Builder getSafeVersionsQueryBuilder() {
        return this.safeVersionsQuery;
    }

    public SafeVersionsResponse.Builder putSafeVersions(long key, List<SafeVersionsResponse.SafeVersion> value) {
        Preconditions.checkNotNull(value);
        this.safeVersions.put(key, value);
        return (SafeVersionsResponse.Builder)this;
    }

    @JsonProperty(value="safeVersions")
    public SafeVersionsResponse.Builder putAllSafeVersions(Map<? extends Long, ? extends List<SafeVersionsResponse.SafeVersion>> map) {
        for (Map.Entry<? extends Long, ? extends List<SafeVersionsResponse.SafeVersion>> entry : map.entrySet()) {
            this.putSafeVersions(entry.getKey(), entry.getValue());
        }
        return (SafeVersionsResponse.Builder)this;
    }

    public SafeVersionsResponse.Builder removeSafeVersions(long key) {
        this.safeVersions.remove(key);
        return (SafeVersionsResponse.Builder)this;
    }

    public SafeVersionsResponse.Builder mutateSafeVersions(Consumer<? super Map<Long, List<SafeVersionsResponse.SafeVersion>>> mutator) {
        mutator.accept(this.safeVersions);
        return (SafeVersionsResponse.Builder)this;
    }

    public SafeVersionsResponse.Builder clearSafeVersions() {
        this.safeVersions.clear();
        return (SafeVersionsResponse.Builder)this;
    }

    public Map<Long, List<SafeVersionsResponse.SafeVersion>> getSafeVersions() {
        return Collections.unmodifiableMap(this.safeVersions);
    }

    public SafeVersionsResponse.Builder mergeFrom(SafeVersionsResponse value) {
        this.safeVersionsQuery.mergeFrom(value.getSafeVersionsQuery());
        this.putAllSafeVersions(value.getSafeVersions());
        return (SafeVersionsResponse.Builder)this;
    }

    public SafeVersionsResponse.Builder mergeFrom(SafeVersionsResponse.Builder template) {
        SafeVersionsResponse.Builder base = template;
        this.safeVersionsQuery.mergeFrom(template.getSafeVersionsQueryBuilder());
        this.putAllSafeVersions(base.safeVersions);
        return (SafeVersionsResponse.Builder)this;
    }

    public SafeVersionsResponse.Builder clear() {
        this.safeVersionsQuery.clear();
        this.safeVersions.clear();
        return (SafeVersionsResponse.Builder)this;
    }

    public SafeVersionsResponse build() {
        return new Value(this);
    }

    @VisibleForTesting
    public SafeVersionsResponse buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements SafeVersionsResponse {
        private final SafeVersionsQuery safeVersionsQuery;
        private final Map<Long, List<SafeVersionsResponse.SafeVersion>> safeVersions;

        Partial(SafeVersionsResponse_Builder builder) {
            this.safeVersionsQuery = builder.safeVersionsQuery.buildPartial();
            this.safeVersions = ImmutableMap.copyOf((Map)builder.safeVersions);
        }

        @Override
        @JsonProperty(value="safeVersionsQuery")
        public SafeVersionsQuery getSafeVersionsQuery() {
            return this.safeVersionsQuery;
        }

        @Override
        @JsonProperty(value="safeVersions")
        public Map<Long, List<SafeVersionsResponse.SafeVersion>> getSafeVersions() {
            return this.safeVersions;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.safeVersionsQuery, other.safeVersionsQuery) && Objects.equals(this.safeVersions, other.safeVersions);
        }

        public int hashCode() {
            return Objects.hash(this.safeVersionsQuery, this.safeVersions);
        }

        public String toString() {
            return "partial SafeVersionsResponse{" + COMMA_JOINER.join((Object)("safeVersionsQuery=" + this.safeVersionsQuery), (Object)("safeVersions=" + this.safeVersions), new Object[0]) + "}";
        }
    }

    private static final class Value
    implements SafeVersionsResponse {
        private final SafeVersionsQuery safeVersionsQuery;
        private final Map<Long, List<SafeVersionsResponse.SafeVersion>> safeVersions;

        private Value(SafeVersionsResponse_Builder builder) {
            this.safeVersionsQuery = builder.safeVersionsQuery.build();
            this.safeVersions = ImmutableMap.copyOf((Map)builder.safeVersions);
        }

        @Override
        @JsonProperty(value="safeVersionsQuery")
        public SafeVersionsQuery getSafeVersionsQuery() {
            return this.safeVersionsQuery;
        }

        @Override
        @JsonProperty(value="safeVersions")
        public Map<Long, List<SafeVersionsResponse.SafeVersion>> getSafeVersions() {
            return this.safeVersions;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.safeVersionsQuery, other.safeVersionsQuery) && Objects.equals(this.safeVersions, other.safeVersions);
        }

        public int hashCode() {
            return Objects.hash(this.safeVersionsQuery, this.safeVersions);
        }

        public String toString() {
            return "SafeVersionsResponse{safeVersionsQuery=" + this.safeVersionsQuery + ", safeVersions=" + this.safeVersions + "}";
        }
    }
}

