/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.git;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Strings;
import com.sourceclear.api.data.git.GitCommit;
import com.sourceclear.api.data.git.RefType;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
@Immutable
public class MetaGit
implements Serializable {
    private static final long serialVersionUID = 3L;
    private final URI localPath;
    private final String subPath;
    private final URI remote;
    private final String head;
    private final String refName;
    private final RefType refType;
    private final List<GitCommit> commits;
    private final int commitHistory;

    private MetaGit(Builder builder) {
        if (builder.commitHistory < 0) {
            throw new IllegalArgumentException("commitHistory must be greater than or equal to 0");
        }
        Objects.requireNonNull(builder.localPath, "MetaGit requires a non-null \"localPath\"");
        Objects.requireNonNull(builder.head, "MetaGit requires a non-null \"head\"");
        Objects.requireNonNull(builder.refType, "MetaGit requires a non-null \"refType\"");
        Objects.requireNonNull(builder.commits, "MetaGit requires a non-null \"commits\"");
        this.localPath = builder.localPath;
        this.subPath = Strings.nullToEmpty((String)builder.subPath);
        this.remote = builder.remote;
        this.head = builder.head;
        this.refName = builder.refName;
        this.refType = builder.refType;
        this.commits = Collections.unmodifiableList(builder.commits);
        this.commitHistory = builder.commitHistory;
    }

    public URI getLocalPath() {
        return this.localPath;
    }

    @Nonnull
    public String getSubPath() {
        return this.subPath;
    }

    @Nullable
    public URI getRemote() {
        return this.remote;
    }

    @Nonnull
    public String getHead() {
        return this.head;
    }

    @Nonnull
    public String getRefName() {
        return this.refName;
    }

    @Nonnull
    public RefType getRefType() {
        return this.refType;
    }

    @Nonnull
    public List<GitCommit> getCommits() {
        return this.commits;
    }

    @Nonnegative
    public int getCommitHistory() {
        return this.commitHistory;
    }

    public static class Builder {
        private URI localPath;
        private String subPath;
        private URI remote;
        private String head;
        private String refName;
        private RefType refType;
        private List<GitCommit> commits;
        private int commitHistory;

        public Builder withLocalPath(URI localPath) {
            this.localPath = localPath;
            return this;
        }

        public Builder withSubPath(String subPath) {
            this.subPath = subPath;
            return this;
        }

        public Builder withRemote(URI remote) {
            this.remote = remote;
            return this;
        }

        public Builder withHead(String head) {
            this.head = head;
            return this;
        }

        public Builder withRefName(String refName) {
            this.refName = refName;
            return this;
        }

        public Builder withRefType(RefType refType) {
            this.refType = refType;
            return this;
        }

        public Builder withCommits(List<GitCommit> commits) {
            this.commits = commits;
            return this;
        }

        public Builder withCommitHistory(int commitHistory) {
            this.commitHistory = commitHistory;
            return this;
        }

        public MetaGit build() {
            return new MetaGit(this);
        }
    }
}

