/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.git;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sourceclear.api.data.git.GitUser;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public class GitCommit
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final GitUser author;
    private final GitUser committer;
    private final Date commitDate;
    private final String commitHash;

    @JsonCreator
    public GitCommit(@JsonProperty(value="author") @Nonnull GitUser author, @JsonProperty(value="committer") @Nonnull GitUser committer, @JsonProperty(value="commitDate") @Nonnull Date commitDate, @JsonProperty(value="commitHash") @Nonnull String commitHash) {
        Objects.requireNonNull(author, "A git commit must have a non-null \"author\"");
        Objects.requireNonNull(committer, "A git commit must have a non-null \"committer\"");
        Objects.requireNonNull(commitDate, "A git commit must have a non-null \"commitDate\"");
        Objects.requireNonNull(commitHash, "A git commit must have a non-null \"commitHash\"");
        this.author = author;
        this.committer = committer;
        this.commitDate = commitDate;
        this.commitHash = commitHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitCommit gitCommit = (GitCommit)o;
        if (!this.getAuthor().equals(gitCommit.getAuthor())) {
            return false;
        }
        if (!this.getCommitter().equals(gitCommit.getCommitter())) {
            return false;
        }
        if (!this.getCommitDate().equals(gitCommit.getCommitDate())) {
            return false;
        }
        return this.getCommitHash().equals(gitCommit.getCommitHash());
    }

    public int hashCode() {
        return Objects.hash(this.author, this.committer, this.commitDate, this.commitHash);
    }

    private void throwIfNull(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    @Nonnull
    public GitUser getAuthor() {
        return this.author;
    }

    @Nonnull
    public GitUser getCommitter() {
        return this.committer;
    }

    @Nonnull
    public Date getCommitDate() {
        return this.commitDate;
    }

    @Nonnull
    public String getCommitHash() {
        return this.commitHash;
    }
}

