/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.evidence;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;

public final class BoundedSortedSet<E extends Comparable<E>> {
    private final NavigableSet<E> set;
    private final int size;

    public BoundedSortedSet(int size) {
        this.size = size;
        this.set = new TreeSet();
    }

    public void add(E e) {
        this.set.add(e);
        this.bound();
    }

    public void addAll(Collection<E> elements) {
        this.set.addAll(elements);
        this.bound();
    }

    public List<E> toList() {
        return Lists.newArrayList(this.set.iterator());
    }

    private void bound() {
        while (this.set.size() > this.size) {
            this.set.pollLast();
        }
    }
}

