/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.events.ScanSuccessEvent;
import java.net.URI;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class ScanSuccessEvent_ScanModel_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private long id;
    private String commit = null;
    private String branch = null;
    private String tag = null;
    private URI reportLink;
    private int vulnIssuesCount;
    private int outofDateIssuesCount;
    private int licenseIssuesCount;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    ScanSuccessEvent_ScanModel_Builder() {
    }

    public static ScanSuccessEvent.ScanModel.Builder from(ScanSuccessEvent.ScanModel value) {
        return new ScanSuccessEvent.ScanModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="id")
    public ScanSuccessEvent.ScanModel.Builder setId(long id) {
        this.id = id;
        this._unsetProperties.remove((Object)Property.ID);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder mapId(UnaryOperator<Long> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setId((Long)mapper.apply(this.getId()));
    }

    public long getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    public ScanSuccessEvent.ScanModel.Builder setCommit(String commit) {
        this.commit = (String)Preconditions.checkNotNull((Object)commit);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    @JsonProperty(value="commit")
    public ScanSuccessEvent.ScanModel.Builder setCommit(Optional<? extends String> commit) {
        if (commit.isPresent()) {
            return this.setCommit(commit.get());
        }
        return this.clearCommit();
    }

    public ScanSuccessEvent.ScanModel.Builder setNullableCommit(@Nullable String commit) {
        if (commit != null) {
            return this.setCommit(commit);
        }
        return this.clearCommit();
    }

    public ScanSuccessEvent.ScanModel.Builder mapCommit(UnaryOperator<String> mapper) {
        return this.setCommit(this.getCommit().map(mapper));
    }

    public ScanSuccessEvent.ScanModel.Builder clearCommit() {
        this.commit = null;
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public Optional<String> getCommit() {
        return Optional.ofNullable(this.commit);
    }

    public ScanSuccessEvent.ScanModel.Builder setBranch(String branch) {
        this.branch = (String)Preconditions.checkNotNull((Object)branch);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    @JsonProperty(value="branch")
    public ScanSuccessEvent.ScanModel.Builder setBranch(Optional<? extends String> branch) {
        if (branch.isPresent()) {
            return this.setBranch(branch.get());
        }
        return this.clearBranch();
    }

    public ScanSuccessEvent.ScanModel.Builder setNullableBranch(@Nullable String branch) {
        if (branch != null) {
            return this.setBranch(branch);
        }
        return this.clearBranch();
    }

    public ScanSuccessEvent.ScanModel.Builder mapBranch(UnaryOperator<String> mapper) {
        return this.setBranch(this.getBranch().map(mapper));
    }

    public ScanSuccessEvent.ScanModel.Builder clearBranch() {
        this.branch = null;
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public Optional<String> getBranch() {
        return Optional.ofNullable(this.branch);
    }

    public ScanSuccessEvent.ScanModel.Builder setTag(String tag) {
        this.tag = (String)Preconditions.checkNotNull((Object)tag);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    @JsonProperty(value="tag")
    public ScanSuccessEvent.ScanModel.Builder setTag(Optional<? extends String> tag) {
        if (tag.isPresent()) {
            return this.setTag(tag.get());
        }
        return this.clearTag();
    }

    public ScanSuccessEvent.ScanModel.Builder setNullableTag(@Nullable String tag) {
        if (tag != null) {
            return this.setTag(tag);
        }
        return this.clearTag();
    }

    public ScanSuccessEvent.ScanModel.Builder mapTag(UnaryOperator<String> mapper) {
        return this.setTag(this.getTag().map(mapper));
    }

    public ScanSuccessEvent.ScanModel.Builder clearTag() {
        this.tag = null;
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public Optional<String> getTag() {
        return Optional.ofNullable(this.tag);
    }

    @JsonProperty(value="reportLink")
    public ScanSuccessEvent.ScanModel.Builder setReportLink(URI reportLink) {
        this.reportLink = (URI)Preconditions.checkNotNull((Object)reportLink);
        this._unsetProperties.remove((Object)Property.REPORT_LINK);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder mapReportLink(UnaryOperator<URI> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setReportLink((URI)mapper.apply(this.getReportLink()));
    }

    public URI getReportLink() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.REPORT_LINK) ? 1 : 0) != 0, (Object)"reportLink not set");
        return this.reportLink;
    }

    @JsonProperty(value="vulnIssuesCount")
    public ScanSuccessEvent.ScanModel.Builder setVulnIssuesCount(int vulnIssuesCount) {
        this.vulnIssuesCount = vulnIssuesCount;
        this._unsetProperties.remove((Object)Property.VULN_ISSUES_COUNT);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder mapVulnIssuesCount(UnaryOperator<Integer> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setVulnIssuesCount((Integer)mapper.apply(this.getVulnIssuesCount()));
    }

    public int getVulnIssuesCount() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.VULN_ISSUES_COUNT) ? 1 : 0) != 0, (Object)"vulnIssuesCount not set");
        return this.vulnIssuesCount;
    }

    @JsonProperty(value="outofDateIssuesCount")
    public ScanSuccessEvent.ScanModel.Builder setOutofDateIssuesCount(int outofDateIssuesCount) {
        this.outofDateIssuesCount = outofDateIssuesCount;
        this._unsetProperties.remove((Object)Property.OUTOF_DATE_ISSUES_COUNT);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder mapOutofDateIssuesCount(UnaryOperator<Integer> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setOutofDateIssuesCount((Integer)mapper.apply(this.getOutofDateIssuesCount()));
    }

    public int getOutofDateIssuesCount() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.OUTOF_DATE_ISSUES_COUNT) ? 1 : 0) != 0, (Object)"outofDateIssuesCount not set");
        return this.outofDateIssuesCount;
    }

    @JsonProperty(value="licenseIssuesCount")
    public ScanSuccessEvent.ScanModel.Builder setLicenseIssuesCount(int licenseIssuesCount) {
        this.licenseIssuesCount = licenseIssuesCount;
        this._unsetProperties.remove((Object)Property.LICENSE_ISSUES_COUNT);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder mapLicenseIssuesCount(UnaryOperator<Integer> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setLicenseIssuesCount((Integer)mapper.apply(this.getLicenseIssuesCount()));
    }

    public int getLicenseIssuesCount() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.LICENSE_ISSUES_COUNT) ? 1 : 0) != 0, (Object)"licenseIssuesCount not set");
        return this.licenseIssuesCount;
    }

    public ScanSuccessEvent.ScanModel.Builder mergeFrom(ScanSuccessEvent.ScanModel value) {
        ScanSuccessEvent.ScanModel.Builder _defaults = new ScanSuccessEvent.ScanModel.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.ID) || !Objects.equals(value.getId(), ((ScanSuccessEvent_ScanModel_Builder)_defaults).getId())) {
            this.setId(value.getId());
        }
        value.getCommit().ifPresent(this::setCommit);
        value.getBranch().ifPresent(this::setBranch);
        value.getTag().ifPresent(this::setTag);
        if (_defaults._unsetProperties.contains((Object)Property.REPORT_LINK) || !Objects.equals(value.getReportLink(), ((ScanSuccessEvent_ScanModel_Builder)_defaults).getReportLink())) {
            this.setReportLink(value.getReportLink());
        }
        if (_defaults._unsetProperties.contains((Object)Property.VULN_ISSUES_COUNT) || !Objects.equals(value.getVulnIssuesCount(), ((ScanSuccessEvent_ScanModel_Builder)_defaults).getVulnIssuesCount())) {
            this.setVulnIssuesCount(value.getVulnIssuesCount());
        }
        if (_defaults._unsetProperties.contains((Object)Property.OUTOF_DATE_ISSUES_COUNT) || !Objects.equals(value.getOutofDateIssuesCount(), ((ScanSuccessEvent_ScanModel_Builder)_defaults).getOutofDateIssuesCount())) {
            this.setOutofDateIssuesCount(value.getOutofDateIssuesCount());
        }
        if (_defaults._unsetProperties.contains((Object)Property.LICENSE_ISSUES_COUNT) || !Objects.equals(value.getLicenseIssuesCount(), ((ScanSuccessEvent_ScanModel_Builder)_defaults).getLicenseIssuesCount())) {
            this.setLicenseIssuesCount(value.getLicenseIssuesCount());
        }
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder mergeFrom(ScanSuccessEvent.ScanModel.Builder template) {
        ScanSuccessEvent.ScanModel.Builder base = template;
        ScanSuccessEvent.ScanModel.Builder _defaults = new ScanSuccessEvent.ScanModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.ID) || !_defaults._unsetProperties.contains((Object)Property.ID) && Objects.equals(template.getId(), ((ScanSuccessEvent_ScanModel_Builder)_defaults).getId()))) {
            this.setId(template.getId());
        }
        template.getCommit().ifPresent(this::setCommit);
        template.getBranch().ifPresent(this::setBranch);
        template.getTag().ifPresent(this::setTag);
        if (!(base._unsetProperties.contains((Object)Property.REPORT_LINK) || !_defaults._unsetProperties.contains((Object)Property.REPORT_LINK) && Objects.equals(template.getReportLink(), ((ScanSuccessEvent_ScanModel_Builder)_defaults).getReportLink()))) {
            this.setReportLink(template.getReportLink());
        }
        if (!(base._unsetProperties.contains((Object)Property.VULN_ISSUES_COUNT) || !_defaults._unsetProperties.contains((Object)Property.VULN_ISSUES_COUNT) && Objects.equals(template.getVulnIssuesCount(), ((ScanSuccessEvent_ScanModel_Builder)_defaults).getVulnIssuesCount()))) {
            this.setVulnIssuesCount(template.getVulnIssuesCount());
        }
        if (!(base._unsetProperties.contains((Object)Property.OUTOF_DATE_ISSUES_COUNT) || !_defaults._unsetProperties.contains((Object)Property.OUTOF_DATE_ISSUES_COUNT) && Objects.equals(template.getOutofDateIssuesCount(), ((ScanSuccessEvent_ScanModel_Builder)_defaults).getOutofDateIssuesCount()))) {
            this.setOutofDateIssuesCount(template.getOutofDateIssuesCount());
        }
        if (!(base._unsetProperties.contains((Object)Property.LICENSE_ISSUES_COUNT) || !_defaults._unsetProperties.contains((Object)Property.LICENSE_ISSUES_COUNT) && Objects.equals(template.getLicenseIssuesCount(), ((ScanSuccessEvent_ScanModel_Builder)_defaults).getLicenseIssuesCount()))) {
            this.setLicenseIssuesCount(template.getLicenseIssuesCount());
        }
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel.Builder clear() {
        ScanSuccessEvent.ScanModel.Builder _defaults = new ScanSuccessEvent.ScanModel.Builder();
        this.id = _defaults.id;
        this.commit = _defaults.commit;
        this.branch = _defaults.branch;
        this.tag = _defaults.tag;
        this.reportLink = _defaults.reportLink;
        this.vulnIssuesCount = _defaults.vulnIssuesCount;
        this.outofDateIssuesCount = _defaults.outofDateIssuesCount;
        this.licenseIssuesCount = _defaults.licenseIssuesCount;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (ScanSuccessEvent.ScanModel.Builder)this;
    }

    public ScanSuccessEvent.ScanModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public ScanSuccessEvent.ScanModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements ScanSuccessEvent.ScanModel {
        private final long id;
        private final String commit;
        private final String branch;
        private final String tag;
        private final URI reportLink;
        private final int vulnIssuesCount;
        private final int outofDateIssuesCount;
        private final int licenseIssuesCount;
        private final EnumSet<Property> _unsetProperties;

        Partial(ScanSuccessEvent_ScanModel_Builder builder) {
            this.id = builder.id;
            this.commit = builder.commit;
            this.branch = builder.branch;
            this.tag = builder.tag;
            this.reportLink = builder.reportLink;
            this.vulnIssuesCount = builder.vulnIssuesCount;
            this.outofDateIssuesCount = builder.outofDateIssuesCount;
            this.licenseIssuesCount = builder.licenseIssuesCount;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="commit")
        public Optional<String> getCommit() {
            return Optional.ofNullable(this.commit);
        }

        @Override
        @JsonProperty(value="branch")
        public Optional<String> getBranch() {
            return Optional.ofNullable(this.branch);
        }

        @Override
        @JsonProperty(value="tag")
        public Optional<String> getTag() {
            return Optional.ofNullable(this.tag);
        }

        @Override
        @JsonProperty(value="reportLink")
        public URI getReportLink() {
            if (this._unsetProperties.contains((Object)Property.REPORT_LINK)) {
                throw new UnsupportedOperationException("reportLink not set");
            }
            return this.reportLink;
        }

        @Override
        @JsonProperty(value="vulnIssuesCount")
        public int getVulnIssuesCount() {
            if (this._unsetProperties.contains((Object)Property.VULN_ISSUES_COUNT)) {
                throw new UnsupportedOperationException("vulnIssuesCount not set");
            }
            return this.vulnIssuesCount;
        }

        @Override
        @JsonProperty(value="outofDateIssuesCount")
        public int getOutofDateIssuesCount() {
            if (this._unsetProperties.contains((Object)Property.OUTOF_DATE_ISSUES_COUNT)) {
                throw new UnsupportedOperationException("outofDateIssuesCount not set");
            }
            return this.outofDateIssuesCount;
        }

        @Override
        @JsonProperty(value="licenseIssuesCount")
        public int getLicenseIssuesCount() {
            if (this._unsetProperties.contains((Object)Property.LICENSE_ISSUES_COUNT)) {
                throw new UnsupportedOperationException("licenseIssuesCount not set");
            }
            return this.licenseIssuesCount;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.commit, other.commit) && Objects.equals(this.branch, other.branch) && Objects.equals(this.tag, other.tag) && Objects.equals(this.reportLink, other.reportLink) && Objects.equals(this.vulnIssuesCount, other.vulnIssuesCount) && Objects.equals(this.outofDateIssuesCount, other.outofDateIssuesCount) && Objects.equals(this.licenseIssuesCount, other.licenseIssuesCount) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.commit, this.branch, this.tag, this.reportLink, this.vulnIssuesCount, this.outofDateIssuesCount, this.licenseIssuesCount, this._unsetProperties);
        }

        public String toString() {
            return "partial ScanModel{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.ID) ? "id=" + this.id : null), (Object)(this.commit != null ? "commit=" + this.commit : null), new Object[]{this.branch != null ? "branch=" + this.branch : null, this.tag != null ? "tag=" + this.tag : null, !this._unsetProperties.contains((Object)Property.REPORT_LINK) ? "reportLink=" + this.reportLink : null, !this._unsetProperties.contains((Object)Property.VULN_ISSUES_COUNT) ? "vulnIssuesCount=" + this.vulnIssuesCount : null, !this._unsetProperties.contains((Object)Property.OUTOF_DATE_ISSUES_COUNT) ? "outofDateIssuesCount=" + this.outofDateIssuesCount : null, !this._unsetProperties.contains((Object)Property.LICENSE_ISSUES_COUNT) ? "licenseIssuesCount=" + this.licenseIssuesCount : null}) + "}";
        }
    }

    private static final class Value
    implements ScanSuccessEvent.ScanModel {
        private final long id;
        private final String commit;
        private final String branch;
        private final String tag;
        private final URI reportLink;
        private final int vulnIssuesCount;
        private final int outofDateIssuesCount;
        private final int licenseIssuesCount;

        private Value(ScanSuccessEvent_ScanModel_Builder builder) {
            this.id = builder.id;
            this.commit = builder.commit;
            this.branch = builder.branch;
            this.tag = builder.tag;
            this.reportLink = builder.reportLink;
            this.vulnIssuesCount = builder.vulnIssuesCount;
            this.outofDateIssuesCount = builder.outofDateIssuesCount;
            this.licenseIssuesCount = builder.licenseIssuesCount;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="commit")
        public Optional<String> getCommit() {
            return Optional.ofNullable(this.commit);
        }

        @Override
        @JsonProperty(value="branch")
        public Optional<String> getBranch() {
            return Optional.ofNullable(this.branch);
        }

        @Override
        @JsonProperty(value="tag")
        public Optional<String> getTag() {
            return Optional.ofNullable(this.tag);
        }

        @Override
        @JsonProperty(value="reportLink")
        public URI getReportLink() {
            return this.reportLink;
        }

        @Override
        @JsonProperty(value="vulnIssuesCount")
        public int getVulnIssuesCount() {
            return this.vulnIssuesCount;
        }

        @Override
        @JsonProperty(value="outofDateIssuesCount")
        public int getOutofDateIssuesCount() {
            return this.outofDateIssuesCount;
        }

        @Override
        @JsonProperty(value="licenseIssuesCount")
        public int getLicenseIssuesCount() {
            return this.licenseIssuesCount;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.id, other.id) && Objects.equals(this.commit, other.commit) && Objects.equals(this.branch, other.branch) && Objects.equals(this.tag, other.tag) && Objects.equals(this.reportLink, other.reportLink) && Objects.equals(this.vulnIssuesCount, other.vulnIssuesCount) && Objects.equals(this.outofDateIssuesCount, other.outofDateIssuesCount) && Objects.equals(this.licenseIssuesCount, other.licenseIssuesCount);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.commit, this.branch, this.tag, this.reportLink, this.vulnIssuesCount, this.outofDateIssuesCount, this.licenseIssuesCount);
        }

        public String toString() {
            return "ScanModel{" + COMMA_JOINER.join((Object)("id=" + this.id), (Object)(this.commit != null ? "commit=" + this.commit : null), new Object[]{this.branch != null ? "branch=" + this.branch : null, this.tag != null ? "tag=" + this.tag : null, "reportLink=" + this.reportLink, "vulnIssuesCount=" + this.vulnIssuesCount, "outofDateIssuesCount=" + this.outofDateIssuesCount, "licenseIssuesCount=" + this.licenseIssuesCount}) + "}";
        }
    }

    private static enum Property {
        ID("id"),
        REPORT_LINK("reportLink"),
        VULN_ISSUES_COUNT("vulnIssuesCount"),
        OUTOF_DATE_ISSUES_COUNT("outofDateIssuesCount"),
        LICENSE_ISSUES_COUNT("licenseIssuesCount");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

