/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.diff.IssueType;
import com.sourceclear.api.data.events.IssueModel;
import java.net.URI;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class IssueModel_Vuln_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private IssueType type;
    private long id;
    private IssueModel.IssueStatus status;
    private URI issueUrl = null;
    private Object vuln;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    IssueModel_Vuln_Builder() {
    }

    public static IssueModel.Vuln.Builder from(IssueModel.Vuln value) {
        return new IssueModel.Vuln.Builder().mergeFrom(value);
    }

    @JsonProperty(value="type")
    public IssueModel.Vuln.Builder setType(IssueType type) {
        this.type = (IssueType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln.Builder mapType(UnaryOperator<IssueType> mapper) {
        return this.setType((IssueType)((Object)mapper.apply(this.getType())));
    }

    public IssueType getType() {
        return this.type;
    }

    @JsonProperty(value="id")
    public IssueModel.Vuln.Builder setId(long id) {
        this.id = id;
        this._unsetProperties.remove((Object)Property.ID);
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln.Builder mapId(UnaryOperator<Long> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setId((Long)mapper.apply(this.getId()));
    }

    public long getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    @JsonProperty(value="status")
    public IssueModel.Vuln.Builder setStatus(IssueModel.IssueStatus status) {
        this.status = (IssueModel.IssueStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this._unsetProperties.remove((Object)Property.STATUS);
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln.Builder mapStatus(UnaryOperator<IssueModel.IssueStatus> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setStatus((IssueModel.IssueStatus)((Object)mapper.apply(this.getStatus())));
    }

    public IssueModel.IssueStatus getStatus() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.STATUS) ? 1 : 0) != 0, (Object)"status not set");
        return this.status;
    }

    public IssueModel.Vuln.Builder setIssueUrl(URI issueUrl) {
        this.issueUrl = (URI)Preconditions.checkNotNull((Object)issueUrl);
        return (IssueModel.Vuln.Builder)this;
    }

    @JsonProperty(value="issueUrl")
    public IssueModel.Vuln.Builder setIssueUrl(Optional<? extends URI> issueUrl) {
        if (issueUrl.isPresent()) {
            return this.setIssueUrl(issueUrl.get());
        }
        return this.clearIssueUrl();
    }

    public IssueModel.Vuln.Builder setNullableIssueUrl(@Nullable URI issueUrl) {
        if (issueUrl != null) {
            return this.setIssueUrl(issueUrl);
        }
        return this.clearIssueUrl();
    }

    public IssueModel.Vuln.Builder mapIssueUrl(UnaryOperator<URI> mapper) {
        return this.setIssueUrl(this.getIssueUrl().map(mapper));
    }

    public IssueModel.Vuln.Builder clearIssueUrl() {
        this.issueUrl = null;
        return (IssueModel.Vuln.Builder)this;
    }

    public Optional<URI> getIssueUrl() {
        return Optional.ofNullable(this.issueUrl);
    }

    @JsonProperty(value="vuln")
    public IssueModel.Vuln.Builder setVuln(Object vuln) {
        this.vuln = Preconditions.checkNotNull((Object)vuln);
        this._unsetProperties.remove((Object)Property.VULN);
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln.Builder mapVuln(UnaryOperator<Object> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setVuln(mapper.apply(this.getVuln()));
    }

    public Object getVuln() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.VULN) ? 1 : 0) != 0, (Object)"vuln not set");
        return this.vuln;
    }

    public IssueModel.Vuln.Builder mergeFrom(IssueModel.Vuln value) {
        IssueModel.Vuln.Builder _defaults = new IssueModel.Vuln.Builder();
        if (!Objects.equals((Object)value.getType(), (Object)((IssueModel_Vuln_Builder)_defaults).getType())) {
            this.setType(value.getType());
        }
        if (_defaults._unsetProperties.contains((Object)Property.ID) || !Objects.equals(value.getId(), ((IssueModel_Vuln_Builder)_defaults).getId())) {
            this.setId(value.getId());
        }
        if (_defaults._unsetProperties.contains((Object)Property.STATUS) || !Objects.equals((Object)value.getStatus(), (Object)((IssueModel_Vuln_Builder)_defaults).getStatus())) {
            this.setStatus(value.getStatus());
        }
        value.getIssueUrl().ifPresent(this::setIssueUrl);
        if (_defaults._unsetProperties.contains((Object)Property.VULN) || !Objects.equals(value.getVuln(), ((IssueModel_Vuln_Builder)_defaults).getVuln())) {
            this.setVuln(value.getVuln());
        }
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln.Builder mergeFrom(IssueModel.Vuln.Builder template) {
        IssueModel.Vuln.Builder _defaults = new IssueModel.Vuln.Builder();
        IssueModel.Vuln.Builder base = template;
        if (!Objects.equals((Object)template.getType(), (Object)((IssueModel_Vuln_Builder)_defaults).getType())) {
            this.setType(template.getType());
        }
        if (!(base._unsetProperties.contains((Object)Property.ID) || !_defaults._unsetProperties.contains((Object)Property.ID) && Objects.equals(template.getId(), ((IssueModel_Vuln_Builder)_defaults).getId()))) {
            this.setId(template.getId());
        }
        if (!(base._unsetProperties.contains((Object)Property.STATUS) || !_defaults._unsetProperties.contains((Object)Property.STATUS) && Objects.equals((Object)template.getStatus(), (Object)((IssueModel_Vuln_Builder)_defaults).getStatus()))) {
            this.setStatus(template.getStatus());
        }
        template.getIssueUrl().ifPresent(this::setIssueUrl);
        if (!(base._unsetProperties.contains((Object)Property.VULN) || !_defaults._unsetProperties.contains((Object)Property.VULN) && Objects.equals(template.getVuln(), ((IssueModel_Vuln_Builder)_defaults).getVuln()))) {
            this.setVuln(template.getVuln());
        }
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln.Builder clear() {
        IssueModel.Vuln.Builder _defaults = new IssueModel.Vuln.Builder();
        this.type = _defaults.type;
        this.id = _defaults.id;
        this.status = _defaults.status;
        this.issueUrl = _defaults.issueUrl;
        this.vuln = _defaults.vuln;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (IssueModel.Vuln.Builder)this;
    }

    public IssueModel.Vuln build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public IssueModel.Vuln buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements IssueModel.Vuln {
        private final IssueType type;
        private final long id;
        private final IssueModel.IssueStatus status;
        private final URI issueUrl;
        private final Object vuln;
        private final EnumSet<Property> _unsetProperties;

        Partial(IssueModel_Vuln_Builder builder) {
            this.type = builder.type;
            this.id = builder.id;
            this.status = builder.status;
            this.issueUrl = builder.issueUrl;
            this.vuln = builder.vuln;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="type")
        public IssueType getType() {
            return this.type;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="status")
        public IssueModel.IssueStatus getStatus() {
            if (this._unsetProperties.contains((Object)Property.STATUS)) {
                throw new UnsupportedOperationException("status not set");
            }
            return this.status;
        }

        @Override
        @JsonProperty(value="issueUrl")
        public Optional<URI> getIssueUrl() {
            return Optional.ofNullable(this.issueUrl);
        }

        @Override
        @JsonProperty(value="vuln")
        public Object getVuln() {
            if (this._unsetProperties.contains((Object)Property.VULN)) {
                throw new UnsupportedOperationException("vuln not set");
            }
            return this.vuln;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.issueUrl, other.issueUrl) && Objects.equals(this.vuln, other.vuln) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.id, this.status, this.issueUrl, this.vuln, this._unsetProperties});
        }

        public String toString() {
            return "partial Vuln{" + COMMA_JOINER.join((Object)("type=" + (Object)((Object)this.type)), (Object)(!this._unsetProperties.contains((Object)Property.ID) ? "id=" + this.id : null), new Object[]{!this._unsetProperties.contains((Object)Property.STATUS) ? "status=" + (Object)((Object)this.status) : null, this.issueUrl != null ? "issueUrl=" + this.issueUrl : null, !this._unsetProperties.contains((Object)Property.VULN) ? "vuln=" + this.vuln : null}) + "}";
        }
    }

    private static final class Value
    implements IssueModel.Vuln {
        private final IssueType type;
        private final long id;
        private final IssueModel.IssueStatus status;
        private final URI issueUrl;
        private final Object vuln;

        private Value(IssueModel_Vuln_Builder builder) {
            this.type = builder.type;
            this.id = builder.id;
            this.status = builder.status;
            this.issueUrl = builder.issueUrl;
            this.vuln = builder.vuln;
        }

        @Override
        @JsonProperty(value="type")
        public IssueType getType() {
            return this.type;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="status")
        public IssueModel.IssueStatus getStatus() {
            return this.status;
        }

        @Override
        @JsonProperty(value="issueUrl")
        public Optional<URI> getIssueUrl() {
            return Optional.ofNullable(this.issueUrl);
        }

        @Override
        @JsonProperty(value="vuln")
        public Object getVuln() {
            return this.vuln;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.id, other.id) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.issueUrl, other.issueUrl) && Objects.equals(this.vuln, other.vuln);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.id, this.status, this.issueUrl, this.vuln});
        }

        public String toString() {
            return "Vuln{" + COMMA_JOINER.join((Object)("type=" + (Object)((Object)this.type)), (Object)("id=" + this.id), new Object[]{"status=" + (Object)((Object)this.status), this.issueUrl != null ? "issueUrl=" + this.issueUrl : null, "vuln=" + this.vuln}) + "}";
        }
    }

    private static enum Property {
        ID("id"),
        STATUS("status"),
        VULN("vuln");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

