/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.diff;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.diff.IssueLibraryDependencyMode;
import com.sourceclear.api.data.diff.IssueResourceModel;
import com.sourceclear.api.data.diff.IssueStatus;
import com.sourceclear.api.data.diff.IssueType;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class IssueResourceModel_Builder {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").skipNulls();
    private IssueStatus status;
    private IssueType type;
    private IssueLibraryDependencyMode dependencyMode;
    @Nullable
    private Float issueSeverity = null;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    IssueResourceModel_Builder() {
    }

    public static IssueResourceModel.Builder from(IssueResourceModel value) {
        return new IssueResourceModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="status")
    public IssueResourceModel.Builder setStatus(IssueStatus status) {
        this.status = (IssueStatus)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this._unsetProperties.remove((Object)Property.STATUS);
        return (IssueResourceModel.Builder)this;
    }

    public IssueResourceModel.Builder mapStatus(UnaryOperator<IssueStatus> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setStatus((IssueStatus)((Object)mapper.apply(this.getStatus())));
    }

    public IssueStatus getStatus() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.STATUS) ? 1 : 0) != 0, (Object)"status not set");
        return this.status;
    }

    @JsonProperty(value="type")
    public IssueResourceModel.Builder setType(IssueType type) {
        this.type = (IssueType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this._unsetProperties.remove((Object)Property.TYPE);
        return (IssueResourceModel.Builder)this;
    }

    public IssueResourceModel.Builder mapType(UnaryOperator<IssueType> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setType((IssueType)((Object)mapper.apply(this.getType())));
    }

    public IssueType getType() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.TYPE) ? 1 : 0) != 0, (Object)"type not set");
        return this.type;
    }

    @JsonProperty(value="dependencyMode")
    public IssueResourceModel.Builder setDependencyMode(IssueLibraryDependencyMode dependencyMode) {
        this.dependencyMode = (IssueLibraryDependencyMode)((Object)Preconditions.checkNotNull((Object)((Object)dependencyMode)));
        this._unsetProperties.remove((Object)Property.DEPENDENCY_MODE);
        return (IssueResourceModel.Builder)this;
    }

    public IssueResourceModel.Builder mapDependencyMode(UnaryOperator<IssueLibraryDependencyMode> mapper) {
        Preconditions.checkNotNull(mapper);
        return this.setDependencyMode((IssueLibraryDependencyMode)((Object)mapper.apply(this.getDependencyMode())));
    }

    public IssueLibraryDependencyMode getDependencyMode() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) ? 1 : 0) != 0, (Object)"dependencyMode not set");
        return this.dependencyMode;
    }

    @JsonProperty(value="issueSeverity")
    public IssueResourceModel.Builder setIssueSeverity(@Nullable Float issueSeverity) {
        this.issueSeverity = issueSeverity;
        return (IssueResourceModel.Builder)this;
    }

    public IssueResourceModel.Builder mapIssueSeverity(UnaryOperator<Float> mapper) {
        Preconditions.checkNotNull(mapper);
        Float issueSeverity = this.getIssueSeverity();
        if (issueSeverity != null) {
            this.setIssueSeverity((Float)mapper.apply(issueSeverity));
        }
        return (IssueResourceModel.Builder)this;
    }

    @Nullable
    public Float getIssueSeverity() {
        return this.issueSeverity;
    }

    public IssueResourceModel.Builder mergeFrom(IssueResourceModel value) {
        IssueResourceModel.Builder _defaults = new IssueResourceModel.Builder();
        if (_defaults._unsetProperties.contains((Object)Property.STATUS) || !Objects.equals((Object)value.getStatus(), (Object)((IssueResourceModel_Builder)_defaults).getStatus())) {
            this.setStatus(value.getStatus());
        }
        if (_defaults._unsetProperties.contains((Object)Property.TYPE) || !Objects.equals((Object)value.getType(), (Object)((IssueResourceModel_Builder)_defaults).getType())) {
            this.setType(value.getType());
        }
        if (_defaults._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) || !Objects.equals((Object)value.getDependencyMode(), (Object)((IssueResourceModel_Builder)_defaults).getDependencyMode())) {
            this.setDependencyMode(value.getDependencyMode());
        }
        if (!Objects.equals(value.getIssueSeverity(), ((IssueResourceModel_Builder)_defaults).getIssueSeverity())) {
            this.setIssueSeverity(value.getIssueSeverity());
        }
        return (IssueResourceModel.Builder)this;
    }

    public IssueResourceModel.Builder mergeFrom(IssueResourceModel.Builder template) {
        IssueResourceModel.Builder base = template;
        IssueResourceModel.Builder _defaults = new IssueResourceModel.Builder();
        if (!(base._unsetProperties.contains((Object)Property.STATUS) || !_defaults._unsetProperties.contains((Object)Property.STATUS) && Objects.equals((Object)template.getStatus(), (Object)((IssueResourceModel_Builder)_defaults).getStatus()))) {
            this.setStatus(template.getStatus());
        }
        if (!(base._unsetProperties.contains((Object)Property.TYPE) || !_defaults._unsetProperties.contains((Object)Property.TYPE) && Objects.equals((Object)template.getType(), (Object)((IssueResourceModel_Builder)_defaults).getType()))) {
            this.setType(template.getType());
        }
        if (!(base._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) || !_defaults._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) && Objects.equals((Object)template.getDependencyMode(), (Object)((IssueResourceModel_Builder)_defaults).getDependencyMode()))) {
            this.setDependencyMode(template.getDependencyMode());
        }
        if (!Objects.equals(template.getIssueSeverity(), ((IssueResourceModel_Builder)_defaults).getIssueSeverity())) {
            this.setIssueSeverity(template.getIssueSeverity());
        }
        return (IssueResourceModel.Builder)this;
    }

    public IssueResourceModel.Builder clear() {
        IssueResourceModel.Builder _defaults = new IssueResourceModel.Builder();
        this.status = _defaults.status;
        this.type = _defaults.type;
        this.dependencyMode = _defaults.dependencyMode;
        this.issueSeverity = _defaults.issueSeverity;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(_defaults._unsetProperties);
        return (IssueResourceModel.Builder)this;
    }

    public IssueResourceModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", (Object[])new Object[]{this._unsetProperties});
        return new Value(this);
    }

    @VisibleForTesting
    public IssueResourceModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    implements IssueResourceModel {
        private final IssueStatus status;
        private final IssueType type;
        private final IssueLibraryDependencyMode dependencyMode;
        @Nullable
        private final Float issueSeverity;
        private final EnumSet<Property> _unsetProperties;

        Partial(IssueResourceModel_Builder builder) {
            this.status = builder.status;
            this.type = builder.type;
            this.dependencyMode = builder.dependencyMode;
            this.issueSeverity = builder.issueSeverity;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="status")
        public IssueStatus getStatus() {
            if (this._unsetProperties.contains((Object)Property.STATUS)) {
                throw new UnsupportedOperationException("status not set");
            }
            return this.status;
        }

        @Override
        @JsonProperty(value="type")
        public IssueType getType() {
            if (this._unsetProperties.contains((Object)Property.TYPE)) {
                throw new UnsupportedOperationException("type not set");
            }
            return this.type;
        }

        @Override
        @JsonProperty(value="dependencyMode")
        public IssueLibraryDependencyMode getDependencyMode() {
            if (this._unsetProperties.contains((Object)Property.DEPENDENCY_MODE)) {
                throw new UnsupportedOperationException("dependencyMode not set");
            }
            return this.dependencyMode;
        }

        @Override
        @JsonProperty(value="issueSeverity")
        @Nullable
        public Float getIssueSeverity() {
            return this.issueSeverity;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.dependencyMode, (Object)other.dependencyMode) && Objects.equals(this.issueSeverity, other.issueSeverity) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.status, this.type, this.dependencyMode, this.issueSeverity, this._unsetProperties});
        }

        public String toString() {
            return "partial IssueResourceModel{" + COMMA_JOINER.join((Object)(!this._unsetProperties.contains((Object)Property.STATUS) ? "status=" + (Object)((Object)this.status) : null), (Object)(!this._unsetProperties.contains((Object)Property.TYPE) ? "type=" + (Object)((Object)this.type) : null), new Object[]{!this._unsetProperties.contains((Object)Property.DEPENDENCY_MODE) ? "dependencyMode=" + (Object)((Object)this.dependencyMode) : null, this.issueSeverity != null ? "issueSeverity=" + this.issueSeverity : null}) + "}";
        }
    }

    private static final class Value
    implements IssueResourceModel {
        private final IssueStatus status;
        private final IssueType type;
        private final IssueLibraryDependencyMode dependencyMode;
        @Nullable
        private final Float issueSeverity;

        private Value(IssueResourceModel_Builder builder) {
            this.status = builder.status;
            this.type = builder.type;
            this.dependencyMode = builder.dependencyMode;
            this.issueSeverity = builder.issueSeverity;
        }

        @Override
        @JsonProperty(value="status")
        public IssueStatus getStatus() {
            return this.status;
        }

        @Override
        @JsonProperty(value="type")
        public IssueType getType() {
            return this.type;
        }

        @Override
        @JsonProperty(value="dependencyMode")
        public IssueLibraryDependencyMode getDependencyMode() {
            return this.dependencyMode;
        }

        @Override
        @JsonProperty(value="issueSeverity")
        @Nullable
        public Float getIssueSeverity() {
            return this.issueSeverity;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals((Object)this.dependencyMode, (Object)other.dependencyMode) && Objects.equals(this.issueSeverity, other.issueSeverity);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.status, this.type, this.dependencyMode, this.issueSeverity});
        }

        public String toString() {
            return "IssueResourceModel{" + COMMA_JOINER.join((Object)("status=" + (Object)((Object)this.status)), (Object)("type=" + (Object)((Object)this.type)), new Object[]{"dependencyMode=" + (Object)((Object)this.dependencyMode), this.issueSeverity != null ? "issueSeverity=" + this.issueSeverity : null}) + "}";
        }
    }

    private static enum Property {
        STATUS("status"),
        TYPE("type"),
        DEPENDENCY_MODE("dependencyMode");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

