/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.diff;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DiffQuery
implements Serializable {
    @JsonProperty
    @NotNull
    @Size(min=1)
    private String repoUrl;
    @JsonProperty
    @NotNull
    @Size(min=1)
    private String currentBranch;
    @JsonProperty
    @NotNull
    @Size(min=1)
    private String baseBranch;
    @JsonProperty
    @NotNull
    private String subPath;
    @JsonProperty
    @Nullable
    private String workspaceSlug;

    DiffQuery() {
    }

    public DiffQuery(@Nonnull String repoUrl, @Nonnull String currentBranch, @Nonnull String baseBranch, @Nonnull String subPath, @Nullable String workspaceSlug) {
        this.repoUrl = repoUrl;
        this.currentBranch = currentBranch;
        this.baseBranch = baseBranch;
        this.subPath = subPath;
        this.workspaceSlug = workspaceSlug;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiffQuery that = (DiffQuery)o;
        return Objects.equals(this.repoUrl, that.repoUrl) && Objects.equals(this.currentBranch, that.currentBranch) && Objects.equals(this.baseBranch, that.baseBranch) && Objects.equals(this.subPath, that.subPath) && Objects.equals(this.workspaceSlug, that.workspaceSlug);
    }

    public int hashCode() {
        return Objects.hash(this.repoUrl, this.currentBranch, this.baseBranch, this.subPath, this.workspaceSlug);
    }

    public String toString() {
        return "DiffQuery{repoUrl='" + this.repoUrl + '\'' + ", currentBranch='" + this.currentBranch + '\'' + ", baseBranch='" + this.baseBranch + '\'' + ", subPath='" + this.subPath + '\'' + ", workspaceSlug='" + this.workspaceSlug + '\'' + '}';
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public String getCurrentBranch() {
        return this.currentBranch;
    }

    public String getBaseBranch() {
        return this.baseBranch;
    }

    public String getSubPath() {
        return this.subPath;
    }

    @Nullable
    public String getWorkspaceSlug() {
        return this.workspaceSlug;
    }
}

