/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.artifact;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.sourceclear.api.data.HATEOASApiModel;
import com.sourceclear.api.data.artifact.ArtifactComponent;
import com.sourceclear.api.data.artifact.ArtifactLink;
import com.sourceclear.api.data.artifact.CVEStatus;
import com.sourceclear.api.data.artifact.Researcher;
import com.sourceclear.api.data.artifact.SourceClearUserApiModel;
import com.sourceclear.api.data.artifact.VersionRange;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.text.WordUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LibraryArtifactApiModel
extends HATEOASApiModel {
    private static final long serialVersionUID = 2L;
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="createdDate")
    private Date createdDate;
    @JsonProperty(value="updatedDate")
    private Date updatedDate;
    @JsonProperty(value="stage")
    private String stage;
    @JsonProperty(value="createdBy")
    private SourceClearUserApiModel createdBy;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="overview")
    private String overview;
    @JsonProperty(value="teardown")
    private String teardown;
    @JsonProperty(value="exploit")
    private String exploit;
    @JsonProperty(value="language")
    private String language;
    @JsonProperty(value="vulnerabilityTypes")
    private List<String> vulnerabilityTypes = Lists.newArrayList();
    @JsonProperty(value="nvdCvssScore")
    private Float nvdCvssScore;
    @JsonProperty(value="nvdCvssVector")
    private String nvdCvssVector;
    @JsonProperty(value="srcclrCvssScore")
    private Float srcclrCvssScore;
    @JsonProperty(value="srcclrCvssVector")
    private String srcclrCvssVector;
    @JsonProperty(value="nvdCvss3Score")
    private Float nvdCvss3Score;
    @JsonProperty(value="nvdCvss3Vector")
    private String nvdCvss3Vector;
    @JsonProperty(value="srcclrCvss3Score")
    private Float srcclrCvss3Score;
    @JsonProperty(value="srcclrCvss3Vector")
    private String srcclrCvss3Vector;
    @JsonProperty(value="artifactComponents")
    private List<ArtifactComponent> artifactComponents = Lists.newArrayList();
    @JsonProperty(value="cveYear")
    private String cveYear;
    @JsonProperty(value="cveDigits")
    private String cveDigits;
    @JsonProperty(value="cveStatus")
    private CVEStatus cveStatus;
    @JsonProperty(value="artifactLinks")
    private List<ArtifactLink> artifactLinks = Lists.newArrayList();
    @JsonProperty(value="researcher")
    private Researcher researcher;
    private boolean community;
    @JsonProperty
    private int priceInCents;
    @JsonProperty
    private Date disclosureDate;
    @JsonProperty
    private Date releasedDate;
    @JsonProperty
    private boolean hasExploits;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryArtifactApiModel)) {
            return false;
        }
        LibraryArtifactApiModel that = (LibraryArtifactApiModel)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
    }

    public String getStage() {
        return this.stage;
    }

    public void setStage(String stage) {
        this.stage = stage;
    }

    public SourceClearUserApiModel getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(SourceClearUserApiModel createdBy) {
        this.createdBy = createdBy;
    }

    public String getTitle() {
        return WordUtils.capitalize((String)this.title);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getOverview() {
        return this.overview;
    }

    public void setOverview(String overview) {
        this.overview = overview;
    }

    public String getTeardown() {
        return this.teardown;
    }

    public void setTeardown(String teardown) {
        this.teardown = teardown;
    }

    public String getExploit() {
        return this.exploit;
    }

    public void setExploit(String exploit) {
        this.exploit = exploit;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<String> getVulnerabilityTypes() {
        return this.vulnerabilityTypes;
    }

    public void setVulnerabilityTypes(List<String> vulnerabilityTypes) {
        this.vulnerabilityTypes = vulnerabilityTypes;
    }

    public Float getNvdCvssScore() {
        return this.nvdCvssScore;
    }

    public void setNvdCvssScore(Float nvdCvssScore) {
        this.nvdCvssScore = nvdCvssScore;
    }

    public String getNvdCvssVector() {
        return this.nvdCvssVector;
    }

    public void setNvdCvssVector(String nvdCvssVector) {
        this.nvdCvssVector = nvdCvssVector;
    }

    public Float getSrcclrCvssScore() {
        return this.srcclrCvssScore;
    }

    public void setSrcclrCvssScore(Float srcclrCvssScore) {
        this.srcclrCvssScore = srcclrCvssScore;
    }

    public String getSrcclrCvssVector() {
        return this.srcclrCvssVector;
    }

    public void setSrcclrCvssVector(String srcclrCvssVector) {
        this.srcclrCvssVector = srcclrCvssVector;
    }

    public List<ArtifactComponent> getArtifactComponents() {
        return this.artifactComponents;
    }

    public void setArtifactComponents(List<ArtifactComponent> artifactComponents) {
        this.artifactComponents = artifactComponents;
    }

    public String getCveYear() {
        return this.cveYear;
    }

    public void setCveYear(String cveYear) {
        this.cveYear = cveYear;
    }

    public String getCveDigits() {
        return this.cveDigits;
    }

    public void setCveDigits(String cveDigits) {
        this.cveDigits = cveDigits;
    }

    public CVEStatus getCveStatus() {
        return this.cveStatus;
    }

    public void setCveStatus(CVEStatus cveStatus) {
        this.cveStatus = cveStatus;
    }

    public List<ArtifactLink> getArtifactLinks() {
        return this.artifactLinks;
    }

    public void setArtifactLinks(List<ArtifactLink> artifactLinks) {
        this.artifactLinks = artifactLinks;
    }

    public Researcher getResearcher() {
        return this.researcher;
    }

    public void setResearcher(Researcher researcher) {
        this.researcher = researcher;
    }

    public boolean isCommunity() {
        return this.community;
    }

    public void setCommunity(boolean community) {
        this.community = community;
    }

    public int getPriceInCents() {
        return this.priceInCents;
    }

    public void setPriceInCents(int priceInCents) {
        this.priceInCents = priceInCents;
    }

    public Date getDisclosureDate() {
        return this.disclosureDate;
    }

    public void setDisclosureDate(Date disclosureDate) {
        this.disclosureDate = disclosureDate;
    }

    public boolean getHasExploits() {
        return this.hasExploits;
    }

    public void setHasExploits(boolean hasExploits) {
        this.hasExploits = hasExploits;
    }

    public Date getReleasedDate() {
        return this.releasedDate;
    }

    public void setReleasedDate(Date releasedDate) {
        this.releasedDate = releasedDate;
    }

    public void clearPremiumData() {
        this.setTeardown(null);
        this.setArtifactLinks(null);
        for (ArtifactComponent artifactComponent : this.artifactComponents) {
            artifactComponent.setVersionRanges(new ArrayList<VersionRange>());
        }
    }

    public Optional<String> getCve() {
        String cve = this.cveYear != null && this.cveDigits != null ? this.cveYear + "-" + this.cveDigits : null;
        return Optional.ofNullable(cve);
    }

    public Optional<Float> getNvdCvss3Score() {
        return Optional.ofNullable(this.nvdCvss3Score);
    }

    public void setNvdCvss3Score(Float nvdCvss3Score) {
        this.nvdCvss3Score = nvdCvss3Score;
    }

    public Optional<String> getNvdCvss3Vector() {
        return Optional.ofNullable(this.nvdCvss3Vector);
    }

    public void setNvdCvss3Vector(String nvdCvss3Vector) {
        this.nvdCvss3Vector = nvdCvss3Vector;
    }

    public Optional<Float> getSrcclrCvss3Score() {
        return Optional.ofNullable(this.srcclrCvss3Score);
    }

    public void setSrcclrCvss3Score(Float srcclrCvss3Score) {
        this.srcclrCvss3Score = srcclrCvss3Score;
    }

    public Optional<String> getSrcclrCvss3Vector() {
        return Optional.ofNullable(this.srcclrCvss3Vector);
    }

    public void setSrcclrCvss3Vector(String srcclrCvss3Vector) {
        this.srcclrCvss3Vector = srcclrCvss3Vector;
    }
}

