/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.IdentifierSet;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Rpc;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;

final class Pruner {
    final Schema schema;
    final IdentifierSet identifierSet;
    final MarkSet marks;
    final Deque<Object> queue;

    Pruner(Schema schema, IdentifierSet identifierSet) {
        this.schema = schema;
        this.identifierSet = identifierSet;
        this.marks = new MarkSet(identifierSet);
        this.queue = new ArrayDeque<Object>();
    }

    public Schema prune() {
        this.markRoots();
        this.markReachable();
        ImmutableList<ProtoFile> retained = this.retainImports(this.retainAll(this.schema, this.marks));
        return new Schema((Iterable<ProtoFile>)retained);
    }

    private ImmutableList<ProtoFile> retainAll(Schema schema, MarkSet marks) {
        ImmutableList.Builder retained = ImmutableList.builder();
        for (ProtoFile protoFile : schema.protoFiles()) {
            retained.add((Object)protoFile.retainAll(schema, marks));
        }
        return retained.build();
    }

    private ImmutableList<ProtoFile> retainImports(ImmutableList<ProtoFile> protoFiles) {
        ImmutableList.Builder retained = ImmutableList.builder();
        for (ProtoFile protoFile : protoFiles) {
            retained.add((Object)protoFile.retainImports((List<ProtoFile>)protoFiles));
        }
        return retained.build();
    }

    private void markRoots() {
        for (ProtoFile protoFile : this.schema.protoFiles()) {
            this.markRoots(protoFile);
        }
    }

    private void markRoots(ProtoFile protoFile) {
        for (Type type : protoFile.types()) {
            this.markRootsIncludingNested(type);
        }
        for (Service service : protoFile.services()) {
            this.markRoots(service.type());
        }
    }

    private void markRootsIncludingNested(Type type) {
        this.markRoots(type.type());
        for (Type nested : type.nestedTypes()) {
            this.markRootsIncludingNested(nested);
        }
    }

    private void markRoots(ProtoType protoType) {
        if (this.identifierSet.includes(protoType)) {
            this.marks.root(protoType);
            this.queue.add(protoType);
            return;
        }
        for (Object reachable : this.reachableObjects(protoType)) {
            ProtoMember member;
            if (!(reachable instanceof ProtoMember) || !this.identifierSet.includes(member = (ProtoMember)reachable)) continue;
            this.marks.root(member);
            this.marks.mark(member.type());
            this.queue.add(member);
        }
    }

    private void markReachable() {
        Object root;
        while ((root = this.queue.poll()) != null) {
            List<Object> reachableMembers = this.reachableObjects(root);
            for (Object reachable : reachableMembers) {
                if (reachable instanceof ProtoType) {
                    if (!this.marks.mark((ProtoType)reachable)) continue;
                    this.queue.add(reachable);
                    continue;
                }
                if (reachable instanceof ProtoMember) {
                    if (!this.marks.mark((ProtoMember)reachable)) continue;
                    this.queue.add(reachable);
                    continue;
                }
                throw new IllegalStateException("unexpected object: " + reachable);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Object> reachableObjects(Object root) {
        Options options;
        ArrayList<Object> result = new ArrayList<Object>();
        if (root instanceof ProtoMember) {
            ProtoMember protoMember = (ProtoMember)root;
            Object member = ((ProtoMember)root).member();
            Type type = this.schema.getType(protoMember.type());
            Service service = this.schema.getService(protoMember.type());
            if (type instanceof MessageType) {
                Field field = ((MessageType)type).field((String)member);
                if (field == null) {
                    field = ((MessageType)type).extensionField((String)member);
                }
                if (field == null) {
                    throw new IllegalStateException("unexpected member: " + (String)member);
                }
                result.add(field.type());
                options = field.options();
            } else if (type instanceof EnumType) {
                EnumConstant constant = ((EnumType)type).constant((String)member);
                if (constant == null) {
                    throw new IllegalStateException("unexpected member: " + (String)member);
                }
                options = constant.getOptions();
            } else {
                if (service == null) throw new IllegalStateException("unexpected member: " + (String)member);
                Object rpc = service.rpc((String)member);
                if (rpc == null) {
                    throw new IllegalStateException("unexpected rpc: " + (String)member);
                }
                result.add(((Rpc)rpc).requestType());
                result.add(((Rpc)rpc).responseType());
                options = ((Rpc)rpc).options();
            }
        } else {
            if (!(root instanceof ProtoType)) throw new IllegalStateException("unexpected root: " + root);
            ProtoType protoType = (ProtoType)root;
            if (protoType.isMap()) {
                result.add(protoType.keyType());
                result.add(protoType.valueType());
                return result;
            }
            if (protoType.isScalar()) {
                return result;
            }
            Type type = this.schema.getType(protoType);
            Service service = this.schema.getService(protoType);
            if (type instanceof MessageType) {
                options = type.options();
                MessageType messageType = (MessageType)type;
                for (Field field : messageType.declaredFields()) {
                    result.add(ProtoMember.get(protoType, field.name()));
                }
                for (Field field : messageType.extensionFields()) {
                    result.add(ProtoMember.get(protoType, field.qualifiedName()));
                }
                for (OneOf oneOf : messageType.oneOfs()) {
                    for (Field field : oneOf.fields()) {
                        result.add(ProtoMember.get(protoType, field.name()));
                    }
                }
            } else if (type instanceof EnumType) {
                options = type.options();
                EnumType wireEnum = (EnumType)type;
                for (EnumConstant constant : wireEnum.constants()) {
                    result.add(ProtoMember.get(wireEnum.type(), constant.getName()));
                }
            } else {
                if (service == null) throw new IllegalStateException("unexpected type: " + protoType);
                options = service.options();
                for (Object rpc : service.rpcs()) {
                    result.add(ProtoMember.get(service.type(), ((Rpc)rpc).name()));
                }
            }
        }
        for (Object member : options.fields().values()) {
            if (this.isExtensionField((ProtoMember)member)) {
                result.add(((ProtoMember)member).type());
            }
            result.add(member);
        }
        return result;
    }

    private boolean isExtensionField(ProtoMember protoMember) {
        Type type = this.schema.getType(protoMember.type());
        return type instanceof MessageType && ((MessageType)type).field(protoMember.member()) != null;
    }
}

