/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.schema.EnumConstant;
import com.squareup.wire.schema.EnumType;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.JvmClassMappingKt;

final class SchemaProtoAdapterFactory {
    final Schema schema;
    final boolean includeUnknown;
    final Map<ProtoType, ProtoAdapter<?>> adapterMap = new LinkedHashMap();

    SchemaProtoAdapterFactory(Schema schema, boolean includeUnknown) {
        this.schema = schema;
        this.includeUnknown = includeUnknown;
        this.adapterMap.put(ProtoType.BOOL, ProtoAdapter.BOOL);
        this.adapterMap.put(ProtoType.BYTES, ProtoAdapter.BYTES);
        this.adapterMap.put(ProtoType.DOUBLE, ProtoAdapter.DOUBLE);
        this.adapterMap.put(ProtoType.FLOAT, ProtoAdapter.FLOAT);
        this.adapterMap.put(ProtoType.FIXED32, ProtoAdapter.FIXED32);
        this.adapterMap.put(ProtoType.FIXED64, ProtoAdapter.FIXED64);
        this.adapterMap.put(ProtoType.INT32, ProtoAdapter.INT32);
        this.adapterMap.put(ProtoType.INT64, ProtoAdapter.INT64);
        this.adapterMap.put(ProtoType.SFIXED32, ProtoAdapter.SFIXED32);
        this.adapterMap.put(ProtoType.SFIXED64, ProtoAdapter.SFIXED64);
        this.adapterMap.put(ProtoType.SINT32, ProtoAdapter.SINT32);
        this.adapterMap.put(ProtoType.SINT64, ProtoAdapter.SINT64);
        this.adapterMap.put(ProtoType.STRING, ProtoAdapter.STRING);
        this.adapterMap.put(ProtoType.UINT32, ProtoAdapter.UINT32);
        this.adapterMap.put(ProtoType.UINT64, ProtoAdapter.UINT64);
    }

    public ProtoAdapter<Object> get(ProtoType protoType) {
        if (protoType.isMap()) {
            throw new UnsupportedOperationException("map types not supported");
        }
        ProtoAdapter<?> result = this.adapterMap.get(protoType);
        if (result != null) {
            return result;
        }
        Type type = this.schema.getType(protoType);
        if (type == null) {
            throw new IllegalArgumentException("unknown type: " + protoType);
        }
        if (type instanceof EnumType) {
            EnumAdapter enumAdapter = new EnumAdapter((EnumType)type);
            this.adapterMap.put(protoType, enumAdapter);
            return enumAdapter;
        }
        if (type instanceof MessageType) {
            MessageAdapter messageAdapter = new MessageAdapter(this.includeUnknown);
            this.adapterMap.put(protoType, messageAdapter);
            for (com.squareup.wire.schema.Field field : ((MessageType)type).fields()) {
                Field fieldAdapter = new Field(field.name(), field.tag(), field.isRepeated(), this.get(field.type()));
                messageAdapter.fieldsByName.put(field.name(), fieldAdapter);
                messageAdapter.fieldsByTag.put(field.tag(), fieldAdapter);
            }
            return messageAdapter;
        }
        throw new IllegalArgumentException("unexpected type: " + protoType);
    }

    static class Field {
        final String name;
        final int tag;
        final boolean repeated;
        final ProtoAdapter<?> protoAdapter;

        Field(String name, int tag, boolean repeated, ProtoAdapter<?> protoAdapter) {
            this.name = name;
            this.tag = tag;
            this.repeated = repeated;
            this.protoAdapter = protoAdapter;
        }
    }

    static final class MessageAdapter
    extends ProtoAdapter<Map<String, Object>> {
        final Map<Integer, Field> fieldsByTag = new LinkedHashMap<Integer, Field>();
        final Map<String, Field> fieldsByName = new LinkedHashMap<String, Field>();
        final boolean includeUnknown;

        MessageAdapter(boolean includeUnknown) {
            super(FieldEncoding.LENGTH_DELIMITED, JvmClassMappingKt.getKotlinClass(Map.class));
            this.includeUnknown = includeUnknown;
        }

        public Map<String, Object> redact(Map<String, Object> message) {
            throw new UnsupportedOperationException();
        }

        public int encodedSize(Map<String, Object> value) {
            int size = 0;
            for (Map.Entry<String, Object> entry : value.entrySet()) {
                Field field = this.fieldsByName.get(entry.getKey());
                if (field == null) continue;
                ProtoAdapter<?> protoAdapter = field.protoAdapter;
                if (field.repeated) {
                    for (Object o : (List)entry.getValue()) {
                        size += protoAdapter.encodedSizeWithTag(field.tag, o);
                    }
                    continue;
                }
                size += protoAdapter.encodedSizeWithTag(field.tag, entry.getValue());
            }
            return size;
        }

        public void encode(ProtoWriter writer, Map<String, Object> value) throws IOException {
            for (Map.Entry<String, Object> entry : value.entrySet()) {
                Field field = this.fieldsByName.get(entry.getKey());
                if (field == null) continue;
                ProtoAdapter<?> protoAdapter = field.protoAdapter;
                if (field.repeated) {
                    for (Object o : (List)entry.getValue()) {
                        protoAdapter.encodeWithTag(writer, field.tag, o);
                    }
                    continue;
                }
                protoAdapter.encodeWithTag(writer, field.tag, entry.getValue());
            }
        }

        public Map<String, Object> decode(ProtoReader reader) throws IOException {
            int tag;
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            long token = reader.beginMessage();
            while ((tag = reader.nextTag()) != -1) {
                Field field = this.fieldsByTag.get(tag);
                if (field == null) {
                    if (this.includeUnknown) {
                        String name = Integer.toString(tag);
                        field = new Field(name, tag, true, reader.peekFieldEncoding().rawProtoAdapter());
                    } else {
                        reader.skip();
                        continue;
                    }
                }
                Object value = field.protoAdapter.decode(reader);
                if (field.repeated) {
                    ArrayList<Object> values = (ArrayList<Object>)result.get(field.name);
                    if (values == null) {
                        values = new ArrayList<Object>();
                        result.put(field.name, values);
                    }
                    values.add(value);
                    continue;
                }
                result.put(field.name, value);
            }
            reader.endMessageAndGetUnknownFields(token);
            return result;
        }

        public String toString(Map<String, Object> value) {
            throw new UnsupportedOperationException();
        }
    }

    static final class EnumAdapter
    extends ProtoAdapter<Object> {
        final EnumType enumType;

        EnumAdapter(EnumType enumType) {
            super(FieldEncoding.VARINT, JvmClassMappingKt.getKotlinClass(Object.class));
            this.enumType = enumType;
        }

        public int encodedSize(Object value) {
            throw new UnsupportedOperationException();
        }

        public void encode(ProtoWriter writer, Object value) throws IOException {
            if (value instanceof String) {
                EnumConstant constant = this.enumType.constant((String)value);
                writer.writeVarint32(constant.getTag());
            } else if (value instanceof Integer) {
                writer.writeVarint32(((Integer)value).intValue());
            } else {
                throw new IllegalArgumentException("unexpected " + this.enumType.type() + ": " + value);
            }
        }

        public Object decode(ProtoReader reader) throws IOException {
            Integer value = (Integer)ProtoAdapter.UINT32.decode(reader);
            EnumConstant constant = this.enumType.constant(value);
            return constant != null ? constant.getName() : value;
        }

        public Object redact(Object value) {
            throw new UnsupportedOperationException();
        }
    }
}

