/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.IdentifierSet;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoFile;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Pruner;
import com.squareup.wire.schema.SchemaProtoAdapterFactory;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public final class Schema {
    private static final Ordering<ProtoFile> PATH_ORDER = new Ordering<ProtoFile>(){

        public int compare(ProtoFile left, ProtoFile right) {
            return left.location().getPath().compareTo(right.location().getPath());
        }
    };
    private final ImmutableList<ProtoFile> protoFiles;
    private final ImmutableMap<String, Type> typesIndex;
    private final ImmutableMap<String, Service> servicesIndex;

    Schema(Iterable<ProtoFile> protoFiles) {
        this.protoFiles = PATH_ORDER.immutableSortedCopy(protoFiles);
        this.typesIndex = Schema.buildTypesIndex(protoFiles);
        this.servicesIndex = Schema.buildServicesIndex(protoFiles);
    }

    public ImmutableList<ProtoFile> protoFiles() {
        return this.protoFiles;
    }

    public ProtoFile protoFile(String path) {
        for (ProtoFile protoFile : this.protoFiles) {
            if (!protoFile.location().getPath().equals(path)) continue;
            return protoFile;
        }
        return null;
    }

    public Schema prune(IdentifierSet identifierSet) {
        return new Pruner(this, identifierSet).prune();
    }

    public Service getService(String name) {
        return (Service)this.servicesIndex.get((Object)name);
    }

    public Service getService(ProtoType protoType) {
        return this.getService(protoType.toString());
    }

    public Type getType(String name) {
        return (Type)this.typesIndex.get((Object)name);
    }

    public Type getType(ProtoType protoType) {
        return this.getType(protoType.toString());
    }

    public Field getField(ProtoMember protoMember) {
        Type type = this.getType(protoMember.type());
        if (!(type instanceof MessageType)) {
            return null;
        }
        Field field = ((MessageType)type).field(protoMember.member());
        if (field == null) {
            field = ((MessageType)type).extensionField(protoMember.member());
        }
        return field;
    }

    private static ImmutableMap<String, Type> buildTypesIndex(Iterable<ProtoFile> protoFiles) {
        LinkedHashMap<String, Type> result = new LinkedHashMap<String, Type>();
        for (ProtoFile protoFile : protoFiles) {
            for (Type type : protoFile.types()) {
                Schema.index(result, type);
            }
        }
        return ImmutableMap.copyOf(result);
    }

    private static void index(Map<String, Type> typesByName, Type type) {
        typesByName.put(type.type().toString(), type);
        for (Type nested : type.nestedTypes()) {
            Schema.index(typesByName, nested);
        }
    }

    private static ImmutableMap<String, Service> buildServicesIndex(Iterable<ProtoFile> protoFiles) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (ProtoFile protoFile : protoFiles) {
            for (Service service : protoFile.services()) {
                result.put((Object)service.type().toString(), (Object)service);
            }
        }
        return result.build();
    }

    public ProtoAdapter<Object> protoAdapter(String typeName, boolean includeUnknown) {
        Type type = this.getType(typeName);
        if (type == null) {
            throw new IllegalArgumentException("unexpected type " + typeName);
        }
        return new SchemaProtoAdapterFactory(this, includeUnknown).get(type.type());
    }
}

