/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Extend;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Service;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.ExtendElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.util.List;

public final class ProtoFile {
    static final ProtoMember JAVA_PACKAGE = ProtoMember.get(Options.FILE_OPTIONS, "java_package");
    private final Location location;
    private final List<String> imports;
    private final List<String> publicImports;
    private final String packageName;
    private final List<Type> types;
    private final List<Service> services;
    private final List<Extend> extendList;
    private final Options options;
    private final Syntax syntax;
    private Object javaPackage;

    private ProtoFile(Location location, List<String> imports, List<String> publicImports, String packageName, List<Type> types, List<Service> services, List<Extend> extendList, Options options, Syntax syntax) {
        this.location = location;
        this.imports = imports;
        this.publicImports = publicImports;
        this.packageName = packageName;
        this.types = types;
        this.services = services;
        this.extendList = extendList;
        this.options = options;
        this.syntax = syntax;
    }

    static ProtoFile get(ProtoFileElement protoFileElement) {
        String packageName = protoFileElement.getPackageName();
        ImmutableList<Type> types = Type.fromElements(packageName, protoFileElement.getTypes());
        ImmutableList<Service> services = Service.fromElements(packageName, protoFileElement.getServices());
        ImmutableList<Extend> wireExtends = Extend.fromElements(packageName, protoFileElement.getExtendDeclarations());
        Options options = new Options(Options.FILE_OPTIONS, protoFileElement.getOptions());
        return new ProtoFile(protoFileElement.getLocation(), protoFileElement.getImports(), protoFileElement.getPublicImports(), packageName, (List<Type>)types, (List<Service>)services, (List<Extend>)wireExtends, options, protoFileElement.getSyntax());
    }

    ProtoFileElement toElement() {
        return new ProtoFileElement(this.location, this.packageName, this.syntax, this.imports, this.publicImports, (List<? extends TypeElement>)Type.toElements(this.types), (List<ServiceElement>)Service.toElements(this.services), (List<ExtendElement>)Extend.toElements(this.extendList), (List<OptionElement>)this.options.toElements());
    }

    public Location location() {
        return this.location;
    }

    List<String> imports() {
        return this.imports;
    }

    List<String> publicImports() {
        return this.publicImports;
    }

    public String name() {
        String result = this.location().getPath();
        int slashIndex = result.lastIndexOf(47);
        if (slashIndex != -1) {
            result = result.substring(slashIndex + 1);
        }
        if (result.endsWith(".proto")) {
            result = result.substring(0, result.length() - ".proto".length());
        }
        return result;
    }

    public String packageName() {
        return this.packageName;
    }

    public String javaPackage() {
        return this.javaPackage != null ? String.valueOf(this.javaPackage) : null;
    }

    public List<Type> types() {
        return this.types;
    }

    public List<Service> services() {
        return this.services;
    }

    List<Extend> extendList() {
        return this.extendList;
    }

    public Options options() {
        return this.options;
    }

    ProtoFile retainAll(Schema schema, MarkSet markSet) {
        ImmutableList.Builder retainedTypes = ImmutableList.builder();
        for (Type type : this.types) {
            Type retainedType = type.retainAll(schema, markSet);
            if (retainedType == null) continue;
            retainedTypes.add((Object)retainedType);
        }
        ImmutableList.Builder retainedServices = ImmutableList.builder();
        for (Service service : this.services) {
            Service retainedService = service.retainAll(schema, markSet);
            if (retainedService == null) continue;
            retainedServices.add((Object)retainedService);
        }
        ProtoFile protoFile = new ProtoFile(this.location, this.imports, this.publicImports, this.packageName, (List<Type>)retainedTypes.build(), (List<Service>)retainedServices.build(), this.extendList, this.options.retainAll(schema, markSet), this.syntax);
        protoFile.javaPackage = this.javaPackage;
        return protoFile;
    }

    void linkOptions(Linker linker) {
        this.options.link(linker);
        this.javaPackage = this.options().get(JAVA_PACKAGE);
    }

    public String toString() {
        return this.location().getPath();
    }

    public String toSchema() {
        return this.toElement().toSchema();
    }

    void validate(Linker linker) {
        linker.validateEnumConstantNameUniqueness(this.types);
    }

    public static enum Syntax {
        PROTO_2("proto2"),
        PROTO_3("proto3");

        private final String string;

        private Syntax(String string2) {
            this.string = string2;
        }

        public static Syntax get(String string) {
            for (Syntax syntax : Syntax.values()) {
                if (!syntax.string.equals(string)) continue;
                return syntax;
            }
            throw new IllegalArgumentException("unexpected syntax: " + string);
        }

        public String toString() {
            return this.string;
        }
    }
}

