

package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Location;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ServiceElement extends ServiceElement {

  private final Location location;

  private final String name;

  private final String documentation;

  private final ImmutableList<RpcElement> rpcs;

  private final ImmutableList<OptionElement> options;

  private AutoValue_ServiceElement(
      Location location,
      String name,
      String documentation,
      ImmutableList<RpcElement> rpcs,
      ImmutableList<OptionElement> options) {
    this.location = location;
    this.name = name;
    this.documentation = documentation;
    this.rpcs = rpcs;
    this.options = options;
  }

  @Override
  public Location location() {
    return location;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public String documentation() {
    return documentation;
  }

  @Override
  public ImmutableList<RpcElement> rpcs() {
    return rpcs;
  }

  @Override
  public ImmutableList<OptionElement> options() {
    return options;
  }

  @Override
  public String toString() {
    return "ServiceElement{"
         + "location=" + location + ", "
         + "name=" + name + ", "
         + "documentation=" + documentation + ", "
         + "rpcs=" + rpcs + ", "
         + "options=" + options
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ServiceElement) {
      ServiceElement that = (ServiceElement) o;
      return (this.location.equals(that.location()))
           && (this.name.equals(that.name()))
           && (this.documentation.equals(that.documentation()))
           && (this.rpcs.equals(that.rpcs()))
           && (this.options.equals(that.options()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= location.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= documentation.hashCode();
    h$ *= 1000003;
    h$ ^= rpcs.hashCode();
    h$ *= 1000003;
    h$ ^= options.hashCode();
    return h$;
  }

  static final class Builder implements ServiceElement.Builder {
    private Location location;
    private String name;
    private String documentation;
    private ImmutableList<RpcElement> rpcs;
    private ImmutableList<OptionElement> options;
    Builder() {
    }
    @Override
    public ServiceElement.Builder location(Location location) {
      if (location == null) {
        throw new NullPointerException("Null location");
      }
      this.location = location;
      return this;
    }
    @Override
    public ServiceElement.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public ServiceElement.Builder documentation(String documentation) {
      if (documentation == null) {
        throw new NullPointerException("Null documentation");
      }
      this.documentation = documentation;
      return this;
    }
    @Override
    public ServiceElement.Builder rpcs(ImmutableList<RpcElement> rpcs) {
      if (rpcs == null) {
        throw new NullPointerException("Null rpcs");
      }
      this.rpcs = rpcs;
      return this;
    }
    @Override
    public ServiceElement.Builder options(ImmutableList<OptionElement> options) {
      if (options == null) {
        throw new NullPointerException("Null options");
      }
      this.options = options;
      return this;
    }
    @Override
    public ServiceElement build() {
      String missing = "";
      if (this.location == null) {
        missing += " location";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.documentation == null) {
        missing += " documentation";
      }
      if (this.rpcs == null) {
        missing += " rpcs";
      }
      if (this.options == null) {
        missing += " options";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ServiceElement(
          this.location,
          this.name,
          this.documentation,
          this.rpcs,
          this.options);
    }
  }

}
