

package com.squareup.wire.schema.internal.parser;

import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_OneOfElement extends OneOfElement {

  private final String name;

  private final String documentation;

  private final ImmutableList<FieldElement> fields;

  private final ImmutableList<GroupElement> groups;

  private AutoValue_OneOfElement(
      String name,
      String documentation,
      ImmutableList<FieldElement> fields,
      ImmutableList<GroupElement> groups) {
    this.name = name;
    this.documentation = documentation;
    this.fields = fields;
    this.groups = groups;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public String documentation() {
    return documentation;
  }

  @Override
  public ImmutableList<FieldElement> fields() {
    return fields;
  }

  @Override
  public ImmutableList<GroupElement> groups() {
    return groups;
  }

  @Override
  public String toString() {
    return "OneOfElement{"
         + "name=" + name + ", "
         + "documentation=" + documentation + ", "
         + "fields=" + fields + ", "
         + "groups=" + groups
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof OneOfElement) {
      OneOfElement that = (OneOfElement) o;
      return (this.name.equals(that.name()))
           && (this.documentation.equals(that.documentation()))
           && (this.fields.equals(that.fields()))
           && (this.groups.equals(that.groups()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= documentation.hashCode();
    h$ *= 1000003;
    h$ ^= fields.hashCode();
    h$ *= 1000003;
    h$ ^= groups.hashCode();
    return h$;
  }

  static final class Builder implements OneOfElement.Builder {
    private String name;
    private String documentation;
    private ImmutableList<FieldElement> fields;
    private ImmutableList<GroupElement> groups;
    Builder() {
    }
    @Override
    public OneOfElement.Builder name(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public OneOfElement.Builder documentation(String documentation) {
      if (documentation == null) {
        throw new NullPointerException("Null documentation");
      }
      this.documentation = documentation;
      return this;
    }
    @Override
    public OneOfElement.Builder fields(ImmutableList<FieldElement> fields) {
      if (fields == null) {
        throw new NullPointerException("Null fields");
      }
      this.fields = fields;
      return this;
    }
    @Override
    public OneOfElement.Builder groups(ImmutableList<GroupElement> groups) {
      if (groups == null) {
        throw new NullPointerException("Null groups");
      }
      this.groups = groups;
      return this;
    }
    @Override
    public OneOfElement build() {
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.documentation == null) {
        missing += " documentation";
      }
      if (this.fields == null) {
        missing += " fields";
      }
      if (this.groups == null) {
        missing += " groups";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_OneOfElement(
          this.name,
          this.documentation,
          this.fields,
          this.groups);
    }
  }

}
